#  THIS procedure processes Software packages.  Software packages are
#     are tarred files which have two files in them.  One is the package
#     to be installed and the second is its database entry.  Both must
#     be present for an archive to accept a package.
#
#  A valid software tar file must use the naming convention
#
#          NAME.MAJORVERSION#.MINORVERSION#.rREVISION#.tar
# 
#  A valid software package must use the naming convention
#
#          NAME.MAJORVERSION#.MINORVERSION#.rREVISION#.tgz
#
#  NOTE:  This is not the archived file.  The .tar file is archived which 
#    allows both the database entry and package to be delivered on request.
#
#  The corresponding database entry file nas the name
#
#          NAME.MAJORVERSION#.MINORVERSION#.rREVISION#.dbe
#
# INPUTS:
#    aDir   - the archive directory
#    arInfo - the archive configuration data
#    pF     - list of tar files in the incoming directory

package provide Server 1.0

proc SVprocSW { aDir arInfo pF } {
   global env aCodeDir SySCmDs sCFG

   upvar $arInfo aI
   set owd [pwd]

# SEE if there is anything to process.  

   set nP [llength $pF]
   if { $nP == 0 } { return }

# THIS is the incoming directory for the archive and the database directory

   set iDir [file join $aDir Incoming]
   set dbDir [file join $aDir Database]


# THIS is where the files go

   set pDir $aCodeDir($aI(aCode))
   if ![file isdirectory $pDir] [file mkdir $pDir]

# GO through and untar all of the src files.  A source package can be
#   identified by the fact that when you split it up it has 4 fields
#   as  PKG MJREV MINREVrREV tar.  A binary package has the added field
#   FMT between MINREVrREV and tar.

   cd $iDir
   set pName ""
   set pSrc  ""
   for { set I 0 } { $I < $nP } { incr I } {
      set fName [lindex $pF $I]
      set nF [llength [split $fName "."]] 
      set rName [file rootname $fName]
      lappend pName $rName
      if { $nF == 4 } {
         lappend pSrc 1
         set fName [file join $iDir $fName]
         exec $SySCmDs(tar) -xf $fName
         set fName [file join $iDir $rName.tgz]
         if [file exists $fName] { file delete -force $fName }
         if [file exists $fName] { 
            set TiMe [clock format [clock seconds] -format "%c"]
	    puts $sCFG(efd) "$TiMe: UNABLE TO DELETE $fName" 
	 }
      } else { lappend pSrc 0 }
   }
   cd $owd

# NOW move all of the packages to their final destination

   for { set I 0 } { $I < $nP } { incr I } {
      set pN [lindex $pName $I].tar
      set SrC [lindex $pSrc $I]
      set CpN [file join $iDir $pN]
      if $SrC { 
         set dN [lindex $pName $I].dbe
         set CdN [file join $iDir $dN]
         if { [file exists $CpN] && [file exist $CdN] } {
            set MvTo [file join $pDir $pN]
            file rename -force $CpN $MvTo 
            if ![file exists $MvTo] { 
               set TiMe [clock format [clock seconds] -format "%c"]
	       puts $sCFG(efd) "$TiMe: UNABLE TO RENAME $MvTo" 
	    }
            set MvTo [file join $dbDir $dN]
            file rename -force $CdN $MvTo 
            if ![file exists $MvTo] { 
               set TiMe [clock format [clock seconds] -format "%c"]
	       puts $sCFG(efd) "$TiMe: UNABLE TO RENAME $MvTo" 
	    }
         }
      } else {
         if [file exists $CpN]  {
            set MvTo [file join $pDir $pN]
            file rename -force $CpN $MvTo 
            if ![file exists $MvTo] { puts 
               set TiMe [clock format [clock seconds] -format "%c"]
	       $sCFG(efd) "$TiMe: UNABLE TO RENAME $MvTo" 
	    }
         }
      }
   }

# ADD them into the database

   SVdbAddSW $aDir aI
}
