#  THIS procedure processes bundles of PIDF files or individual PIDF files.  
#     PIDF files are just moved to their Archive data directory and 
#     compressed if necessary. 
#   
# INPUTS:
#    aDir   - the archive directory
#    arInfo - the archive configuration data
#    pF     - list of files and bundles to process

package provide Server 1.0

proc SVprocPIDFS { aDir arInfo pF } {
   global env aCodeDir SySCmDs

   upvar $arInfo aI

   set owd [pwd]

# SEE if there is anything to process.  Find the number of PIDF bundles
#   and individual Files in the directory.

   set nB [llength [lindex $pF 2]]
   set nF [llength [lindex $pF 4]]

   if { ($nB == 0) && ($nF == 0) } { return }

# THIS is the incoming directory for the archive

   set iDir [file join $aDir Incoming]

# THIS is where the files go

   set pDir $aCodeDir($aI(aCode))
   if ![file isdirectory $pDir] [file mkdir $pDir]

# GO through all of the PIDF bundles.  Bundles are uncompressed and untarred
#   in the incoming directory.

   for { set I 0 } { $I < $nB } { incr I } {
      set bName [lindex [lindex $pF 2] $I]
      exec $SySCmDs(gzip) -df [file join $iDir $bName]
      set fC [split $bName "."]
      set fLen [expr [llength $fC] - 1]
      set tF [lindex $fC 0] 
      for { set J 1 } { $J < $fLen } { incr J } { append tF .[lindex $fC $J] }
      append tF ".tar"

      if { [catch { exec $SySCmDs(tar) -xf $tF } eRR ] } {
         if { [string first "lone zero block" $eRR] < 0 } {
             puts stderr "UNRECOVERABLE ERROR!!  $eRR"
	     return 0
	 }
      }

      if [file exists $tF] { file delete -force $tF }
   }

   cd $owd

# NOW move all of the single files into the incoming directory to their final
#  destination - compressing them first if necessary.  A proper PIDF file has
#  the extension v2 so check for a 2 as the final character in the file name
#  as a precaution.

   set pFiles [exec $SySCmDs(ls) $iDir]
   set pLen [llength $pFiles]

   for { set I 0 } { $I < $pLen } { incr I } {
      set pN [lindex $pFiles $I]
      if { [string index $pN end] == "2" } {
         if { $aI(cCode) == 1 } { 
            exec $SySCmDs(gzip) -f [file join $iDir $pN]
            append pN .gz 
         }
         set MvFrom [file join $iDir $pN]
         set MvTo [file join $pDir $pN]
         file rename -force $MvFrom $MvTo 
      }
   }
}
