#  THIS procedure processes bundles of UDF header/data. 
#   
# INPUTS:
#    aDir   - the archive directory
#    arInfo - the archive configuration data
#    pF     - list of files and bundles to process
                                                                                
package provide Server 1.0
                                                                                
proc SVprocHD { aDir arInfo pF } {
   global env aCodeDir SySCmDs sCFG
                                                                                
   upvar $arInfo aI

   set owd [pwd]
                                                                                
# SEE if there is anything to process.  Find the number of HD bundles
#   in the Incoming directory.
                                                                                
   set nB [llength [lindex $pF 0]]
   if { $nB == 0 } { return }

# THIS is the bundle directory for the archive

   set iDir [file join $aDir Incoming]

# NUKE any stale UDFXFER file which may be laying around in the incoming
#   directory.  These are the manifest files included within the data
#   bundles and should have been removed after the data was processed.                                           
   set ManiFest [file join $iDir UDFXFER]
   if [file exists $ManiFest] { file delete -force $ManiFest] }

# LOOP over the bundles and process them one by one.  
#
#   1. Uncompress the bundles and extract their contents.
#   2. Parse the manifest file and create a list of all the files to be
#        processed and what UDF experiment definition they belong too.
#   3. Check for duplicate files in the Archive.  These are removed and
#        their database entries deleted. 
#   4. Convert the data to native format. (Nothing happens here if the data
#      is already in native format).
#   5. Update the Archive database(s).

   cd $iDir
   for { set I 0 } { $I < $nB } { incr I } {
      set bName [lindex [lindex $pF 0] $I]
      exec $SySCmDs(gzip) -df [file join $iDir $bName]
      set fC [split $bName "."]
      set fLen [expr [llength $fC] - 1]
      set tF [lindex $fC 0]
      for { set J 1 } { $J < $fLen } { incr J } { append tF .[lindex $fC $J] }
      append tF ".tar"
      set tF [file join $iDir $tF]

      if { [catch { exec $SySCmDs(tar) -xf $tF } eRR ] } {
         if { [string first "lone zero block" $eRR] < 0 } {
             puts stderr "UNRECOVERABLE ERROR!!  $eRR"
	     return 0
	 }
      }

      if [file exists $tF] { file delete -force $tF }
                                                                                
      if [file exists $ManiFest] { 
         if [catch {open $ManiFest r} fd ] {
            set TiMe [clock format [clock seconds] -format "%c"]
            puts $sCFG(efd) "$TiMe: SVprocHD: CAN'T OPEN $ManiFest From $tF"
	    flush $sCFG(efd)
            return 0
         }
      } else {
         set TiMe [clock format [clock seconds] -format "%c"]
         puts $sCFG(efd) "$TiMe: SVprocHD: $tF has no UDFXFER file!"
	 flush $sCFG(efd)
         return 0
      }

      set pList ""
      gets $fd LiNe
      while { [gets $fd LiNe] >= 0 } {
         set fN [lindex $LiNe 0]
         if { [string index $fN end] != "D" } { continue }
         set bName [string range $fN 0 [expr [string length $fN] - 2]]
         set uExP [lindex [split [lindex $LiNe 1] "/"] 0]
         lappend pList [list $bName $uExP]
      }
      close $fd

      SVdupsCheck $aDir $pList
      SVhdNative $aDir $pList
      SVdbAddHD $aDir aI $pList

# TIME to compress and move the files tho the archive directory.

      set oDir $aCodeDir($aI(aCode))
      if ![file isdirectory $oDir] [file mkdir $oDir]
      set pLen [llength $pList]

      for { set J 0 } { $J < $pLen } { incr J } {
         set bName [lindex [lindex $pList $J] 0]
         set hF ${bName}H 
         set dF ${bName}D
         if { $aI(cCode) == 1 } {
            exec $SySCmDs(gzip) -f [file join $iDir $hF]
            exec $SySCmDs(gzip) -f [file join $iDir $dF]
            append hF ".gz"
            append dF ".gz"
         }
         file rename -force [file join $iDir $hF] [file join $oDir $hF]
         file rename -force [file join $iDir $dF] [file join $oDir $dF]
      }
   } 

   cd $owd
   return 1
}
