# THIS procedure searches an Archive to see if the requested PIDF file
#   is present.  It returnes the information it finds to the client.

package provide Server 1.0

proc SVpidfSearch { sock LiNe } {
   global sDEF aCodeDir sCFG

#  THIS is the archive iD and port number

   set iD [lindex $LiNe 1].[lindex $LiNe 2].P
   set port [lindex $LiNe end]

# FIND the directory which contains the archive databases
                                                                                
   set aDir ""
   for { set I 0 } { $I < $sDEF(aN) } { incr I } {
      if { [string match $iD $sDEF($I,iD)] && ($port == $sDEF($I,Port)) } {
         set aDir $sDEF($I,aDir)
         break
      }
   }

   if { [string length $aDir] == 0 } { return 0 }

# READ the configuration file for this archive.  This will tell us where the
#   data is being kept and if it stored as compressed or uncompressed files.
                                                                                
   set cFg [file join $aDir ArchiveConfig]
   if [catch {open $cFg r} fd ] {
      set TiMe [clock format [clock seconds] -format "%c"]
      puts $sCFG(efd) "$TiMe: SVvidfSearch: CANNOT OPEN $cFg"
      flush $sCFG(efd)
      return 0
   }
                                                                                
   while { [gets $fd aLine] > 0 } {
      set Flds [split $aLine "|"]
      set aI([lindex $Flds 0]) [lindex $Flds 1]
   }
   close $fd

# NOW see if the requested file is in the archive directory 

   set PromoteList ""
   set cN [lindex $LiNe 5].pidf.v2
   if { $aI(cCode) == 1 } { append cN ".gz" }
   set cN [file join $aCodeDir($aI(aCode)) $cN]
   if [file exists $cN] {
      lappend PromoteList [lindex $LiNe 5]
      lappend PromoteList $aCodeDir($aI(aCode))
      lappend PromoteList $aI(cCode)
   } else { lappend PromoteList NONE }
    
   puts $sock $PromoteList
   return 1
}
