#  THIS procedure looks the bundle directory and returns all of the
#     files that it thinks should be processed.  This will depend on 
#     what type of archive this is.
#
# INPUTS:
#    aDir   - the archive directory
#    arInfo - the Archive configuration data

package provide Server 1.0

proc SVgetIncoming { aDir arInfo } {
   global env SySCmDs 

   upvar $arInfo aI

# THIS is the incoming directory for the archive

   set bDir [file join $aDir Incoming]

# THIS is return incoming files to process

   set ReT ""

# SPLIT up the archive ID into its components 

   set aID [split $aI(aID) "."]
   set aType [lindex $aID 0]

# LIST out the contents of the incoming directory.  If there is nothing
#   there we are done. 

   set dFiles [exec $SySCmDs(ls) $bDir]
   set dLen [llength $dFiles]
   if { $dLen == 0 } { return $ReT }

# FILES in Incoming directories can have different formats depending on
#   the archive type.
#
#   In UDF data archives the input files can come in three different formats.
#   UDF header/data always comes in a UDF data bundles which includes a 
#   manifest file listing the included files and their associated experiments.
#   UDF VIDFs and PIDFs can either come in UDF bundles sans the manifest or 
#   just be dropped in to the Incoming directory as individual files.  
#
#   A UDF data bundle can be recoznized from its fixed filename format.
#   It is made up of 5 "." separated fields.  The first two fields are
#   identical to the first two archive iD fields.  The thrid is UDFx where
#   if x is p or v this is a PIDF or VIDF bundle respectively.  If x is any 
#   other character the bundle holds header/data files.  The fourth field is 
#   a time field and the fifth is the tgz extension.
#
#   Software packages have the extension .tar.  They have two naming formats
#     however.  These are either PKG.REV.tar or PKG.REV.FMT.tar.  The FMT
#     field if present indicated a package type other than the normal format
#     and should just be put into the software data area without being
#     having the database updated.  It is assumed to be a binary version
#     of a source package.
#
# NOTE!!!
#   At this point we are going to be very trusting and assume that all of the
#   files in the Incoming directory are files which should be processed for
#   this archive.  IE THERE IS NO GARBAGE IN THE DIRECTORY!

   switch -exact -- $aType {
      software { 
         for { set I 0 } { $I < $dLen } { incr I } {
            set fName [lindex $dFiles $I] 
            set ExT [lindex [split $fName "."] end]
            set Ex1 [string match tar $ExT]
            if { $Ex1 } { lappend ReT $fName } 
         }
      }

      server { 
         for { set I 0 } { $I < $dLen } { incr I } {
            set fName [lindex $dFiles $I] 
            lappend ReT $fName 
         }
      }

      default {
         set bF "" ; set bpF "" ; set bvF "" ; set vF "" ; set pF ""
         for { set I 0 } { $I < $dLen } { incr I } {
            set fName [lindex $dFiles $I] 
            set bType [string index [lindex [split $fName "."] 2] end]
            switch -exact -- [string index $fName end] {
               V  { lappend vF $fName } 
               2  { lappend pF $fName }
               z  { 
                  if { $bType == "v" } { 
                     lappend bvF $fName 
                  } elseif { $bType == "p" } { 
                     lappend bpF $fName  
                  } else { lappend bF $fName }
               }
            }
         }
         set ReT [list $bF $bvF $bpF $vF $pF]
      }
   } 
   return $ReT
}
