# THIS procedure scans at the UDF files to be added to an archive and
#   removes any duplicate entries.
#   
#   INPUTS are:
#      aDir     - the archive base directory
#      ManiFest - the manifest of the files to be checked.  This is a list
#                 of lists.  Each entry is a base UDF file name (last
#                 character of the file name has been stripped from it) and
#                 its UDF Experiment designation
#
#   The procedure actions are:
#
#     1. Remove any duplicate files
#     2. Remove their database entries

package provide Server 1.0

proc SVdupsCheck { aDir ManiFest { dType HD } } {
   global env aCodeDir sCFG

# SET the file ending based on dType

  if { $dType == "I" } { set fEnd V } else { set fEnd D }

# INITIALIZE the remove list.  While duplicate files are removed as we hit 
#   them their database entries are removed with in single call at the end 
#   of the procedure using the remove list as input

   set rmList ""

# LOOP over the UDF files to be transferred into the archive 

   set mLen [llength $ManiFest]
   for { set I 0 } { $I < $mLen } { incr I } {

# GET the base filename and experiment for this list entry.  The experiment 
#   entry allows the Archive database for the data to be determined.

      set Entry [lindex $ManiFest $I]
      set bName [lindex $Entry 0]
      set uExP [lindex $Entry 1]
      set dbF [file join $aDir Database $uExP.$dType.DBF]

# MAKE sure there is a database to check against.  This could be the first
#   installation of this data.

      if ![file exists $dbF] { continue }

# DO the duplicate file check

      set Pos [ DBfileDup $dbF dBInfo $bName]

# POS is a list of positions in the database that contain duplicate file 
#   entries.  Hopefully there is only one duplicate entry if any at all
#   but one never knows. 

      set dLen [llength $Pos]
      for { set J 0 } { $J < $dLen } { incr J } {

# TO remove the duplicate entry we need to get its current database entry.  
#    From that we get the files archive code which tells us where it is
#    stored and its compression code so we know how to formulate its tail.

         set dBKey [lindex $dBInfo(KeyList) [lindex [lindex $Pos $J] 1]]
         set aCode [lindex $dBKey 2]
         set cCode [lindex $dBKey 3]
         if ![info exists aCodeDir($aCode)] {
            set TiMe [clock format [clock seconds] -format "%c"]
            puts $sCFG(efd) "$TiMe: SVdupsCheck: ILLEGAL ARCHIVE CODE $aCode!"
	    flush $sCFG(efd)
         } else {
            lappend rmList [list $uExP [lindex [lindex $Pos $J] 0]]
            if { $fEnd == "I" } {
               if { $cCode == 1 } {
                  set iFile [file join $aCodeDir($aCode) ${bName}V.gz]
               } else {
                  set iFile [file join $aCodeDir($aCode) ${bName}V]
               }
               if [file exists $iFile] { file delete -force $dFile }
            } else {
               if { $cCode == 1 } {
                  set dFile [file join $aCodeDir($aCode) ${bName}D.gz]
                  set hFile [file join $aCodeDir($aCode) ${bName}H.gz]
               } else {
                  set dFile [file join $aCodeDir($aCode) ${bName}D]
                  set hFile [file join $aCodeDir($aCode) ${bName}H]
               }
               if [file exists $dFile] { file delete -force $dFile }
               if [file exists $hFile] { file delete -force $hFile }
            }
         }
      }
   }

# REMOVE all the duplicate database entries.

   SVdbfRemove $aDir $rmList $dType
}
