# THIS procedure searches an Archive database to find all files within
#   a requested time period.  It then puts them all into  a list and 
#   sends this list to the client.

package provide Server 1.0

proc SVdbSearch { sock LiNe dBType } {
   global sDEF aCodeDir sCFG

# THIS is the archive ID

   set iD [lindex $LiNe 1].[lindex $LiNe 2]
   if { $dBType == "I" } { append iD .V }

# THIS is the request port number

   set port [lindex $LiNe end]

# FIND the archive directory.  The databases will be under this directory

   set aDir ""
   for { set I 0 } { $I < $sDEF(aN) } { incr I } {
      if { [string match $iD $sDEF($I,iD)] && ($port == $sDEF($I,Port)) } {
         set aDir $sDEF($I,aDir) 
         break
      }
   }

   if { [string length $aDir] == 0 } { return 0 }
                                                                                
# ESTABLISH the database file, open it, get the appropriate entries and 
#    create the promtion list to send back to the client

   if { $dBType == "I" } { 
      set dB [file join $aDir Database VIDF.I.DBF]
   } else { 
      set dB [file join $aDir Database [lindex $LiNe 3].HD.DBF]
   }

# OPEN and parse the database for any entries of the virtual instrument
#   retuested.

   DBdbfOpen $dB dBInfo [lindex $LiNe 5]

# RETURN the limits in the entry file of all files which contain the time
#   period specified.

   set Lims [DBtimeEntry dBInfo \
                [lindex $LiNe 6] [lindex $LiNe 7] [lindex $LiNe 8] \
                [lindex $LiNe 9] [lindex $LiNe 10] [lindex $LiNe 11] ]

# BUILD the promote list

   set PromoteList ""
   if { [llength $Lims] == 0 } {
      lappend PromotesList NONE
   } else {
      set Start [lindex $Lims 0]
      if { [llength $Lims] == 1 } {
         set End $Start
      } else { set End [lindex $Lims 1] }

      for { set I $Start } { $I <= $End } { incr I } {
         set Rec [lindex $dBInfo(KeyList) $I]
         set ToRec [expr $dBInfo(HLen) + $dBInfo(RecLen) * [lindex $Rec 1]]
         seek $dBInfo(fd) $ToRec start
         set dBRec [read $dBInfo(fd) $dBInfo(RecLen)]
         binary scan $dBRec aa8a4a3a8a4a3a8a10aaa2a3a8 \
                    Sp V bYr bDy bMs eYr eDy eMs fSize P1 cCode St aCode tM
                                                                                
         set V [string trim $V]
         set Yr [string trimleft $bYr]
         set Dy [string trimleft $bDy]
         set Hr [expr int($bMs / 3600000)]
         set Mn [expr int (($bMs % 3600000) / 60000 )]
         set fName [format "%s%4d%03d%02d%02d"  $V $Yr $Dy $Hr $Mn]

         if [info exists aCodeDir($aCode)] {
            set aDir $aCodeDir($aCode)
            lappend PromoteList $fName
            lappend PromoteList $aDir
            lappend PromoteList $cCode
         } else {
            puts $sCFG(ldf) "WARNING: File $fName in $dB has unknown  \
                            Archive Code value $aCode"
         }
      }

      if { [llength $PromoteList] == 0 } { lappend PromoteList NONE }
   }
    
   close $dBInfo(fd)
   set dBInfo(fd) ""

   puts $sock $PromoteList
   return 1
}
