# THIS procedure creates database entries for all of the VIDFs to be inserted 
#    into the archive and updates all of the necessary databases.

package provide Server 1.0

proc SVdbAddV { aDir arInfo pList } {
   global env 

   upvar $arInfo aI

# THIS is the directory where the incoming files are found and where the
#    loose files are.

   set iDir [file join $aDir Incoming]

   set pLen [llength $pList]
   if { $pLen > 0 } {
      set uExP [lindex [lindex $pList 0] 1]
      for { set I 0 } { $I < $pLen } { incr I } {
         set Entry [lindex $pList $I]
         lappend DoList [lindex $Entry 0]
      }

      set dbF [file join $aDir Database ${uExP}.I.DBF]

# THIS is the file where we will generate the database entries

      set dbE [file join $iDir V.asc]
      
# GENERATE the database entries

      DBgenEntries V $iDir $iDir $dbE $DoList $aI(aCode) $aI(cCode)

# APPEND the entries to the database

       DBdbfAppend $dbF $dbE
    }
}
