#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

#include "ADump_str.h"
#include "ADump_ansi.h"

void PrData () 
{
    extern struct UserDefs InFo;

    struct SrcInfo *S;

    register ReaL_8 *d1, *d2;
    register ReaL_4 *f1, *f2;

    static ByTe_1 DoOnce = 1;
    static ByTe_4 MaxLen;

    ByTe_4 HH, MM, SS, MS, N, M, L, Jmp;
    ByTe_4 EnD;
    ByTe_1 *PrFmT3 =   "\n                            ";
    ByTe_1 Blk[55], PFmt[20];
    ByTe_1 Space[50], sCaN;

    S = (struct SrcInfo *)InFo.Src;

    if (DoOnce)
    {
       DoOnce = 0;
       MaxLen = PrHdr (S->Tb.Yr, S->Tb.Dy) + 2;
    }
    sprintf (PFmt, "%%%ds", MaxLen); 
    for (N = 0; N < MaxLen; ++N)
       Space[N] = (N > 1) ? '*' : ' '; 
    Space[N] = 0;

    S = (struct SrcInfo *)InFo.Src;
    for (N = 0; N < InFo.EmptySrc; ++N, ++S) 
    {
       if (S->DLen > 0)
       {
          HH = S->Tb.Ms / 3600000;
          MM = S->Tb.Ms % 3600000 / 60000;
          SS = ((S->Tb.Ms % 3600000) % 60000) / 1000;
          MS = S->Tb.Ms % 1000;  
          fprintf (InFo.fd, "\n%02d:%02d:%02d.%03d - ", HH, MM, SS, MS); 
      
          HH = S->Te.Ms / 3600000;
          MM = S->Te.Ms % 3600000 / 60000;
          SS = ((S->Te.Ms % 3600000) % 60000) / 1000;
          MS = S->Te.Ms % 1000;  
          fprintf (InFo.fd, "%02d:%02d:%02d.%03d ", HH, MM, SS, MS);

          if (S->UDFSrc == 2)
             EnD = (InFo.NAnc > 1) ? S->DLen : 1;
           else
             EnD = S->DLen;
          break;
       }
    }

    for (M = 0; M < EnD; ++M) 
    {
       S = (struct SrcInfo *)InFo.Src;

       if (M > 0)
          fprintf (InFo.fd, PrFmT3);

       sCaN = 1;
       for (N = 0; N < InFo.EmptySrc; ++N, ++S) 
       {
          for (L = 0; L < S->TotMCols; ++L)
          {
             Jmp = L * S->DLen;
             d1 = (ReaL_8 *)S->Pri + M + Jmp;
             d2 = (ReaL_8 *)S->Alt + M;

             if (S->AltUN >= 0 && sCaN)
             {
                sCaN = 0;
                if (InFo.NeedInt == 1)
                   sprintf (Blk, InFo.OutFmt, (ByTe_4)*d2);
                else
                   sprintf (Blk, InFo.OutFmt, *d2);
                fprintf (InFo.fd, PFmt, Blk);
             }

             if (S->Phase != 0)
             {
                f1 = (ReaL_4 *)S->Pha + M;
                f2 = (ReaL_4 *)S->Pha + M + S->DLen;
                if (InFo.NeedInt == 1)
                   sprintf (Blk, InFo.OutFmt, (ByTe_4)*f1);
                else
                   sprintf (Blk, InFo.OutFmt, *f1);
                fprintf (InFo.fd, PFmt, Blk);
                if (InFo.NeedInt == 1)
                   sprintf (Blk, InFo.OutFmt, (ByTe_4)*f2);
                else
                   sprintf (Blk, InFo.OutFmt, *f2);
                fprintf (InFo.fd, PFmt, Blk);
             }

             if (S->Polar != 0)
             {
                f1 = (ReaL_4 *)S->Pol + M;
                f2 = (ReaL_4 *)S->Pol + M + S->DLen;
                if (InFo.NeedInt == 1)
                   sprintf (Blk, InFo.OutFmt, (ByTe_4)*f1);
                else
                   sprintf (Blk, InFo.OutFmt, *f1);
                fprintf (InFo.fd, PFmt, Blk);
                if (InFo.NeedInt == 1)
                   sprintf (Blk, InFo.OutFmt, (ByTe_4)*f2);
                else
                   sprintf (Blk, InFo.OutFmt, *f2);
                fprintf (InFo.fd, PFmt, Blk);
             }

             if (S->DType != 1)
             {
                if (S->DLen == 0)
                   sprintf (Blk, "%s", Space);
                else
                {
                   if (InFo.NeedInt == 1)
                      sprintf (Blk, InFo.OutFmt, (ByTe_4)*d1);
                   else
                      sprintf (Blk, InFo.OutFmt, *d1);
                }
                fprintf (InFo.fd, PFmt, Blk);
             }
          }
      }
   }

   if (EnD > 1)
      fprintf (InFo.fd, "\n");
}
