#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "ADump_str.h"
#include "ADump_ansi.h"

void MenuOneUdf (ByTe_2 SrcN, u_ByTe_2 V)
{
   extern struct MeNuS Ms;
   extern struct UserDefs InFo;

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;
   struct SrcInfo *Sc;

   register ByTe_1  *c1, *c2;

   ByTe_4  PN, Src; 
   ByTe_1  TmpS[10];

   /************************************************************/
   /*             IDFS INFO MENU TRANSFER                      */
   /*                                                          */
   /* ID[00]:  SENSORS [0=ONE; 1=ALL]                          */
   /* ID[01]:  PROJECT                                         */
   /* ID[02]:  MISSION                                         */
   /* ID[03]:  EXPERIMENT                                      */
   /* ID[04]:  INSTRUMENT                                      */
   /* ID[05]:  VIRTUAL                                         */
   /* ID[06]:  DATA TYPE                                       */
   /* ID[07]:  DATA GROUP                                      */
   /* ID[08]:  COMPONENT (VIDF SENSOR NUMBER)                  */
   /* ID[09]:  SENSOR UNITS                                    */
   /* ID[10]:  SCAN UNITS                                      */
   /* ID[12]:  ANCILLARY DATA                                  */
   /* ID[13]:  ANCILLARY UNITS                                 */
   /* ID[14]:  MODE DATA                                       */
   /* ID[15]:  MODE UNITS                                      */
   /* ID[16]:  QUALITY UNITS                                   */
   /************************************************************/

   c1 = (ByTe_1 *)InFo.SrcWns;

   Sc = (struct SrcInfo *)InFo.Src + InFo.EmptySrc++;
   Sc->Pri = 0;
   Sc->Alt = 0;
   Sc->Pha = 0;
   Sc->Pol = 0;

   Src = -1;
   while (Src < SrcN)
   {
      c2 = TmpS;
      while (*c1 == ' ')
         ++c1;
      while((*c1 != ' ') && (*c1 != 0))
         *c2++ = *c1++;
      *c2 = 0;
      sscanf (TmpS, "%d", &PN);
      ++Src;
   }

   Pg = (struct PaGe *) Ms.page + PN;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ;

   Sc->GetUN = -1;
   Sc->AltUN = -1;
   Sc->GetPN = -1;
   Sc->SenPN = -1;
   Sc->Phase = 0;
   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            Sc->OneAll = Qs->OpReply;
         break;
         case 1:
            Sc->P = TransFer (Qs->CReply, 1, 0);
         break;
         case 2:
            Sc->M = TransFer (Qs->CReply, 1, 0);
         break;
         case 3:
            Sc->E = TransFer (Qs->CReply, 1, 0);
         break;
         case 4:
            Sc->I = TransFer (Qs->CReply, 1, 0);
         break;
         case 5:
            Sc->V = TransFer (Qs->CReply, 1, 0);
         break;
         case 6:
            sscanf (Qs->AltVal, "%hd", &Sc->DType);
         break;
         case 7:
            Sc->Group = (Qs->state == 1) ? Qs->OpReply : -1;
         break;
         case 8:
            if (Qs->state == 1)
               sscanf (Qs->AltVal, "%hd", &Sc->SenPN);
            else
               Sc->SenPN = 0;
         break;
         case 9:
         case 13:
         case 15:
         case 16:
            if (Qs->state == 1)
               sscanf (Qs->AltVal, "%hd", &Sc->GetUN);
         break;
         case 10:
            if (Qs->state == 1)
               sscanf (Qs->AltVal, "%hd", &Sc->AltUN);
         break;
         case 12:
         case 14:
            if (Qs->state == 1)
               sscanf (Qs->AltVal, "%hd", &Sc->GetPN);
         break;
         case 17:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%hd", &Sc->SenRN);
            else
               Sc->SenRN = 0;
         break;
         case 18:
            Sc->Phase = Qs->OpReply;
         break;
         case 19:
            Sc->Polar = Qs->OpReply;
         break;
      }

   }
   if (Sc->DType < 2)
      Sc->GetPN = Sc->SenPN;

   if (Sc->OneAll > 0 && Sc->DType > 1)
      Sc->OneAll = 1;

   Sc->BufSize = 0;
   Sc->Ver = V;
}
