#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "ADump_str.h"
#include "ADump_ansi.h"

void GetPidfInfo (ByTe_2 N) 
{
   extern struct UserDefs InFo;

   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfMode *Pm;
   struct PidfSensor *Ps;
   struct PidfAnc *Pa;
   struct SrcInfo *S;

   S = (struct SrcInfo *)InFo.Src + N;

   /**************************************************************************/
   /*  Read the PIDF file                                                    */
   /*  Set pointer to the PIDF information structure                         */
   /*  Set pointer to PIDF sensor info for user requested sensor             */
   /*  Set pointer to PIDF unit info for user requested sensor unit          */
   /**************************************************************************/

   ReadPidf(S->Key, InFo.PIDF);
   P = (struct Pidf *) InFo.PIDF;

   S->UDFSrc = S->DType;
   switch (S->DType)
   {
      case 0:
      case 1:
        Ps = (struct PidfSensor *)P->Sensors + S->GetPN;
        Pu = (struct PidfUnit *)P->Units + S->GetUN;
        S->SenVN =  (Ps->Src == 'A') ? Ps->AncSen : Ps->VidfNum;
        if (Ps->Src == 'A')
           S->UDFSrc = 2;

        S->GetVN = Ps->VidfNum;
        S->GetNAS = Pu->NTbls;

        if (Pu->NTbls > 0)                                       
        {
           S->GetTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
           S->GetOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
        }

        if (S->AltUN >= 0)
           NeedAlt (N);
      break;

      case 2:
        Pa = (struct PidfAnc *)P->Ancil + S->GetPN;
        Pu = (struct PidfUnit *)P->Units + S->GetUN;
        Ps = (struct PidfSensor *)P->Sensors + S->SenPN;

        S->SenVN = Ps->VidfNum;
        S->GetVN = Pa->VidfNum;
        S->GetNAS = Pu->NTbls;

        if (Pu->NTbls > 0)                                       
        {
           S->GetTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
           S->GetOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
        }

        if (S->AltUN >= 0)
           NeedAlt (N);
      break;

      case 6:
        Pm = (struct PidfMode *)P->Modes + S->GetPN;
        Pu = (struct PidfUnit *)P->Units + S->GetUN;

        S->SenVN = 0;
        S->GetVN = Pm->VidfNum;
        S->GetNAS = Pu->NTbls;

        if (Pu->NTbls > 0)                                       
        {
           S->GetTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
           S->GetOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
        }
      break;
   }
}
