/**************************************************************************/
/*  This routine figures out what needs to be malloced and how many bytes */
/*  to allocate for each item                                             */
/**************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "ADump_str.h"
#include "util_str.h"
#include "user_defs.h"
#include "libbase_udf.h"
#include "ADump_ansi.h"

void CheckMem (ByTe_4 N)
{
   extern struct UserDefs InFo;

   struct idf_data  *ExDa;
   struct SrcInfo *S;

   ByTe_4 B;
   ByTe_4 LenA, LenB;

   /**************************************************************************/
   /* Set pointer to the structure which holds all the information which     */
   /* was obtained in the read.                                              */
   /**************************************************************************/

   ExDa = (struct idf_data *) InFo.UDF;              /* ptr to data          */
   S = (struct SrcInfo *) InFo.Src + N;              /* source structure     */

   LenA = S->TotMCols * ExDa->num_sample;            /* pri scan length      */
   LenB = ExDa->num_sample;                          /* alt scan length      */

   if (LenA > S->BufSize)                            /* not enough memory?   */
   {
      B = LenA * sizeof (ReaL_8);                    /* bytes for data store */
      if ((S->Pri = realloc(S->Pri, B)) == 0)        /* mem for Sensor data  */
         ErrorRpt ("CheckMem", 0, 2);                /* oops - error bye     */
      B = LenB * sizeof (ReaL_8);                    /* bytes for alt store  */
      if ((S->Alt = realloc(S->Alt, B)) == 0)        /* mem for Scan data    */
         ErrorRpt ("CheckMem", 0, 2);                /* oops - error bye     */
      if (S->Phase != 0)                             /* get phase data too?  */
      {                                              /* BEG SPACE FOR PHASE  */
         B = 2 * LenB * sizeof (ReaL_4);             /* bytes for alt store  */
         if ((S->Pha = realloc(S->Pha, B)) == 0)     /* mem for Phase data   */
            ErrorRpt ("CheckMem", 0, 2);             /* oops - error bye     */
      }                                              /* END SPACE FOR PHASE  */
      if (S->Polar != 0)                             /* get polar data too?  */
      {                                              /* BEG SPACE FOR PHASE  */
         B = 2 * LenB * sizeof (ReaL_4);             /* bytes for alt store  */
         if ((S->Pol = realloc(S->Pol, B)) == 0)     /* mem for Phase data   */
            ErrorRpt ("CheckMem", 0, 2);             /* oops - error bye     */
      }                                              /* END SPACE FOR PHASE  */
      S->BufSize = LenA;                             /* new buffer size      */
   }
}
