#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfDefs.h"

#include "ADump_str.h"
#include "ADump_ansi.h"

ByTe_4 PrHdr (ByTe_2 Yr, ByTe_2 Dy) 
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   struct Pidf *P;
   struct PidfSensor *Ps;
   struct PidfAnc *Pa;
   struct PidfUnit *Pu;
   struct PidfMode *Pm;

   struct SrcInfo *S;
   ByTe_2 MaxLen, Len, HLen;
   ByTe_2 I, EnD, MeasNo = 0;
   ByTe_1 *c1, *Cs;
   ByTe_1 *Lab1 = "Measurement 1 Scan Data";
   ByTe_1 *Lab2 = "Scan Step Number";
   ByTe_1 *Lab3 = "Integer";
   ByTe_1 *Lab4 = "Beg Phase";
   ByTe_1 *Lab5 = "End Phase";
   ByTe_1 *Lab6 = "Degrees";
   ByTe_1 *Lab7 = "Beg Polar";
   ByTe_1 *Lab8 = "End Polar";
   ByTe_1 ALab[30], BLab[30], TLab[80], *L, *U;

   Cs = (ByTe_1 *)Wa.CStore;

   fprintf (InFo.fd, "UDF ASCII DUMP\n\n");
   fprintf (InFo.fd, "YEAR: %4d\n", Yr);
   fprintf (InFo.fd, "DAY:  %4d\n\n", Dy);
   fprintf (InFo.fd, "DUMP OF:\n\n");
   fprintf (InFo.fd, "      MEASUREMENT");
   fprintf (InFo.fd, "                      UNITS");
   fprintf (InFo.fd, "                    UDF SRC\n");
   fprintf (InFo.fd, "      -----------");
   fprintf (InFo.fd, "                      -----");
   fprintf (InFo.fd, "                    -------\n\n");

   S = (struct SrcInfo *)InFo.Src;

   if ((S->AltUN >= 0 && S->DType != 1) || S->DType == 2)
   {
      if (S->DType != 2)
      {
         ReadPidf (S->Key, InFo.PIDF);
         P = (struct Pidf *)InFo.PIDF;
         Pu = (struct PidfUnit *)P->Units + S->AltUN;
         L = Lab1;
         U = Pu->ULab;
      }
      else
      {
         L = Lab2;
         U = Lab3;
      }
      fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                    MeasNo++, L, U, Cs + S->V);
   }
    
   EnD = InFo.EmptySrc;
   for (I = 0; I < EnD; ++S, ++I)
   {
      ReadPidf (S->Key, InFo.PIDF);
      P = (struct Pidf *)InFo.PIDF;
      Pu = (struct PidfUnit *)P->Units + S->GetUN;

      if (S->Phase != 0)
      {
         fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, Lab4, Lab6, Cs + S->V);
         fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, Lab5, Lab6, Cs + S->V);
      }
      if (S->Polar != 0)
      {
         fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, Lab7, Lab6, Cs + S->V);
         fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, Lab8, Lab6, Cs + S->V);
      }

      switch  (S->DType)
      {
         case 0:
           Ps = (struct PidfSensor *)P->Sensors + S->GetPN;
           if (S->TotMCols == 1)
              fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, Ps->Name, Pu->ULab, Cs + S->V);
           else
           {
              sprintf (TLab, "%s (All Columns)", Ps->Name);
              fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                      MeasNo++, TLab, Pu->ULab, Cs + S->V);
           }
         break;
         case 1:
           Pu = (struct PidfUnit *)P->Units + S->AltUN;
           fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, Pu->LDesc, Pu->ULab, Cs + S->V);
         break;
         case 2:
           Pa = (struct PidfAnc *)P->Ancil + S->GetPN;
           fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, Pa->LDesc, Pu->ULab, Cs + S->V);
         break;
         case 3:
         break;
         case 4:
         break;
         case 5:
           sprintf (ALab, "Quality Data");
           sprintf (BLab, "Unitless");
           fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, ALab, BLab, Cs + S->V);
         break;
         case 6:
           Pm = (struct PidfMode *)P->Modes + S->GetPN;
           fprintf (InFo.fd, "%3d: %-32s [%-20s]   (%s)\n", 
                                   MeasNo++, Pm->LDesc, Pu->ULab, Cs + S->V);
         break;
      }
   }

   fprintf (InFo.fd, "\n\n");

   fprintf (InFo.fd, "  BEG TIME   -   END TIME   ");
   MaxLen = ColSizes();
   Len = MaxLen - 3;
   HLen = Len / 2 + 2;
   c1 = BLab;   
   for (I = 0; I < HLen; ++I)
     *c1++ = ' ';
   *c1++ = '%';
   *c1++ = '0';
   *c1++ = '3';
   *c1++ = 'd';
   HLen -= (Len % 2 == 0) ? 2 : 1;
   for (I = 0; I < HLen; ++I)
     *c1++ = ' ';
   *c1 = 0;
   
   for (I = 0; I < MeasNo; ++I)
      fprintf (InFo.fd, BLab, I);
   fprintf (InFo.fd, "\n");

   fprintf (InFo.fd, "------------   ------------ ");

   c1 = TLab;   
   *c1++ = ' ';
   *c1++ = ' ';
   for (I = 0; I < MaxLen; ++I)
     *c1++ = '-';
   *c1 = 0;

   for (I = 0; I < MeasNo; ++I)
      fprintf (InFo.fd, TLab);

   fprintf (InFo.fd, "\n");

   return (MaxLen);
}
