#include <stdio.h>
#include "LinkList.h"
#include "gen_defs.h"
#include "util_str.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "ADump_str.h"
#include "ADump_ansi.h"

/****************************************************************************/
/*  N:       the offset into the source structure array                     */
/****************************************************************************/

ByTe_2 GetIt (ByTe_4 N)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct general_info ginfo;

   struct experiment_info *ex;
   struct ptr_rec *pTr;
   struct SrcInfo *S, *Sp;
   struct Pidf *P;

   ByTe_4 Bs, Es, I;
   ByTe_2 R;
   ByTe_1 *Cs, *X = "", Mode, NeedOpen = 1;

   Cs = (ByTe_1 *)Wa.CStore;

   S = (struct SrcInfo *)InFo.Src + N;
   R = get_data_key (Cs + S->P, Cs + S->M, Cs + S->E, Cs + S->I,
                     Cs + S->V, &S->Key);
   ErrorRpt ("UDF KEY", R, 1);

   Sp = (struct SrcInfo *)InFo.Src;
   for (I = 0; I < N; ++I ) { 
      if (Sp->Key == S->Key) { 
          NeedOpen = 0;
          break;
      }
   }

   ReadPidf (S->Key, InFo.PIDF);                        /* into the PIDF     */
   if ( NeedOpen ) {
      Bs = InFo.TB.Ms/1000;                             /* beg time in sec   */
      Es = InFo.TE.Ms/1000;                             /* end time in sec   */
      Mode = (S->DType == 6) ? 1 : 0;
      R = file_open (S->Key, X, S->Ver, InFo.TB.Yr, InFo.TB.Dy,  
             Bs, 0, InFo.TE.Yr, InFo.TE.Dy, Es, 0, Mode);
      ErrorRpt ("UDF_OPEN", R, 1) ;                     /* rpt any errors    */

      P = (struct Pidf *) InFo.PIDF;                    /* pointer to info   */
      if (P->Pf.Blocking == 1)                          /* RECORD BOCKING    */
         R = FilePosRec (S->Key, X, S->Ver, InFo.UDF,   /* position to the   */
                      InFo.TB.Yr, InFo.TB.Dy, Bs, 0,    /* nearest record in */
                      InFo.TE.Yr, InFo.TE.Dy, Es, 0);   /* the data file     */
      else                                              /* CLOSEST TIME      */
         R = file_pos (S->Key, X, S->Ver, InFo.UDF,     /* position in file  */
                    InFo.TB.Yr, InFo.TB.Dy, Bs, 0,      /* to nearest time   */ 
                    InFo.TE.Yr, InFo.TE.Dy, Es, 0);

      ErrorRpt ("FILE_POS", R, 1);                      /* rpt any errors    */
   }

   ex = ginfo.expt;
   pTr = ex->info_ptr;
   S->TotMCols = (ex->smp_id == 3 && S->OneAll == 3) ? *pTr->TOT_COLS : 1;

   return (1);
}
