#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"

#include "ADump_str.h"
#include "ADump_ansi.h"

ByTe_2 GetData (ByTe_2 N, ByTe_1 FwD)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct general_info ginfo;

   struct experiment_info *ex;
   struct ptr_rec *pTr; 

   struct SrcInfo *S;
   struct idf_data  *ExDa;

   register ReaL_4 *f1, *f2, *f3, *f4, *fEnD;

   ReaL_8 *d1;
   ByTe_4 sS, nS;
   ByTe_2 *Ss, R, Rs, rN;
   ByTe_1 *Cs;
   ByTe_1 *X = "";

   S = (struct SrcInfo *)InFo.Src + N;
   Cs = (ByTe_1 *)Wa.CStore;
   Ss = (ByTe_2 *)Wa.SStore;
   ExDa = (struct idf_data *) InFo.UDF;

   Rs = read_drec (S->Key, X, S->Ver, InFo.UDF, S->SenVN, S->SenRN, FwD, 0);
   ErrorRpt ("READ_DREC", Rs, 0);

   ex = ginfo.expt;
   pTr = ex->info_ptr;

   S->TotMCols = (ex->smp_id == 3 && S->OneAll == 3) ? ExDa->TotCols : 1;

   if (Rs == ALL_OKAY || ExDa->filled_data)
   {
      CheckMem (N);

   /**************************************************************************/
   /*  Switch on the type of data which is being requested                   */
   /*                                                                        */
   /*  0: Sensor                                                             */
   /*  1: Scan                                                               */
   /*  2: Ancillary                                                          */
   /*  3: Spin Angle                                                         */
   /*  4: Pitch Angle                                                        */
   /*  5: Quality                                                            */
   /*  6: Mode                                                               */
   /**************************************************************************/

      switch (S->UDFSrc) 
      {
         case 0: 
           rN = (S->TotMCols == 1) ? 0 : S->SenRN;
           d1 = (ReaL_8 *)S->Pri + rN * ExDa->num_sample;
           R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, 
                                DSENSOR, 0, S->GetNAS, Cs + S->GetTbls,  
                                Ss + S->GetOps, (ReaL_4 *)d1, 0, 0L);
           ErrorRpt ("CONVERT_TO_UNITS", R, 1);
           S->DLen  = ExDa->num_sample;

         case 1:
            if (S->AltUN >= 0)
              GetAlt (N);
          break;

         case 2:
            if (InFo.NAnc < *(ex->CSET_NUM + S->GetVN))
               InFo.NAnc = *(ex->CSET_NUM + S->GetVN);
            rN = (S->TotMCols == 1) ? 0 : S->SenRN;
            d1 = (ReaL_8 *)S->Pri + rN * ExDa->num_sample;
            R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, 
                           DANCILLARY, S->GetVN, S->GetNAS, Cs + S->GetTbls,  
                             Ss + S->GetOps, (ReaL_4 *)d1, 0, 0L);
            ErrorRpt ("CONVERT_TO_UNITS", R, 1);
            S->DLen  = ExDa->num_sample;

            if (S->AltUN >= 0)
               GetAlt (N);
         break;

         case 5: 
           d1 = (ReaL_8 *)S->Pri;
           *d1 = ExDa->d_qual;
           S->DLen  = 1;
         break;

         case 6: 
           d1 = (ReaL_8 *)S->Pri;
           R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, 
                                DMODE, S->GetVN, S->GetNAS, Cs + S->GetTbls,  
                                Ss + S->GetOps, (ReaL_4 *)d1, 0, 0L);
           ErrorRpt ("CONVERT_TO_UNITS", R, 1);
           S->DLen  = 1;

          break;

      }

      if (S->Phase != 0)
      {
         f1 = (ReaL_4 *)S->Pha;                 /* beg azimuth angles        */
         f2 = (ReaL_4 *)S->Pha + S->DLen;       /* end azimuth angles        */
         f3 = (ReaL_4 *)ExDa->start_az;         /* beg azimuth angles        */
         f4 = (ReaL_4 *)ExDa->stop_az;          /* end azimuth angles        */
         fEnD = f1 + S->DLen;                   /* end of phases             */ 
         for ( ; f1 < fEnD; )                   /* xfer loop                 */
         {                                      /* BEG ANGLE XFER LOOP       */
            *f1++ = *f3++;                      /* xfer a beg azimuth        */
            *f2++ = *f4++;                      /* xfer an end azimuth       */
         }                                      /* END ANGLE XFER LOOP       */
      }

      if (S->Polar != 0)
      {
         f1 = (ReaL_4 *)S->Pol;                 /* beg polar angles          */
         f2 = (ReaL_4 *)S->Pol + S->DLen;       /* end polar angles          */
         f3 = (ReaL_4 *)ExDa->start_theta;      /* beg polar angles          */
         f4 = (ReaL_4 *)ExDa->stop_theta;       /* end polar angles          */
         fEnD = f1 + S->DLen;                   /* end of phases             */ 
         for ( ; f1 < fEnD; )                   /* xfer loop                 */
         {                                      /* BEG ANGLE XFER LOOP       */
            *f1++ = *f3++;                      /* xfer a beg azimuth        */
            *f2++ = *f4++;                      /* xfer an end azimuth       */
         }                                      /* END ANGLE XFER LOOP       */
      }

      S->Tb.Yr = ExDa->byear;
      S->Tb.Dy = ExDa->bday;
      S->Tb.Ms = ExDa->bmilli;
      S->Tb.Ns = ExDa->bnano;
      S->Te.Yr = ExDa->eyear;
      S->Te.Dy = ExDa->eday;
      S->Te.Ms = ExDa->emilli;
      S->Te.Ns = ExDa->enano;
   }
   else
      S->DLen = 0;

   if (FwD == 1)
   {
      sS = (InFo.TE.Ms + (InFo.TE.Ns / 1000000)) / 1000;
      nS = (InFo.TE.Ms % 1000) * 1000000 + InFo.TE.Ns;
      Rs = ReOpenFile (S->Key, X, S->Ver, InFo.UDF, 0, 0, 0, 0,
                       InFo.TE.Yr, InFo.TE.Dy, sS, nS, Rs); 
      ErrorRpt ("REOPENFILE", Rs, 0);
   }

   return (Rs);
}
