#ifndef DUMPEX_H
#define DUMPEX_H
#endif

#include <stdio.h>
#include "ByteDefs.h"

struct TiMiNg
{
   ByTe_2 Yr;
   ByTe_2 Dy;
   ByTe_4 Ms;
   ByTe_4 Ns;
};

struct SrcInfo
{
   u_ByTe_2 P;                      /* IDFS project                         */
   u_ByTe_2 M;                      /* IDFS mission                         */
   u_ByTe_2 E;                      /* IDFS experiment                      */
   u_ByTe_2 I;                      /* IDFS instrument                      */
   u_ByTe_2 V;                      /* IDFS virtual instrument              */
   u_ByTe_4 Key;                    /* IDFS Key                             */
   ByTe_2   DType;                  /* Selected Data Type                   */
   ByTe_2   Group;                  /* Selected Group Number Type           */
   ByTe_2   SenPN;                  /* PIDF SENSOR NUMBER                   */
   ByTe_2   GetPN;                  /* PIDF NUMBER of Item to Get           */
   ByTe_2   GetUN;                  /* PIDF UNIT NUMBER of Item to Get      */
   ByTe_2   AltUN;                  /* PIDF Secondary UNIT NUMBER (Scan)    */
   ByTe_2   SenVN;                  /* VIDF SENSOR NUMBER                   */
   ByTe_2   GetVN;                  /* VIDF NUMBER of Item to Get           */
   ByTe_2   SenRN;                  /* Sensor Matrix ROW NUMBER             */
   ByTe_1   GetNAS;                 /* No. of Algorithm Step in Get Units   */
   ByTe_1   AltNAS;                 /* No. of Algorithm Step in Alt Units   */
   ByTe_1   UDFSrc;                 /* Measurement source in UDF            */
   u_ByTe_2 GetOps;                 /* Scan Operations for Get Units        */
   u_ByTe_2 GetTbls;                /* Tables to apply for Get Units        */
   u_ByTe_2 AltOps;                 /* Scan Operations for Alt Units        */
   u_ByTe_2 AltTbls;                /* Tables to apply for Alt Units        */
   ByTe_1   Ver;                    /* Version number                       */
   ByTe_1   OneAll;                 /* Do one or all sensors                */
   ByTe_1   Phase;                  /* Output Phase Data                    */
   ByTe_1   Polar;                  /* Output Polar Data                    */
   void     *Pri;                   /* sensor mesh data                     */
   void     *Alt;                   /* scan data                            */
   void     *Pha;                   /* phase data                           */
   void     *Pol;                   /* polar data                           */
   ByTe_4   BufSize;                /* buffer size                          */
   ByTe_2   DLen;                   /* Number of samples retrieved          */
   ByTe_2   TotMCols;               /* Number matrix columns in matrix sen  */
   struct TiMiNg Tb;
   struct TiMiNg Te;
};

struct UserDefs
{
   struct TiMiNg TB;
   struct TiMiNg TE;
   ByTe_1 OutFile[40];
   ByTe_1 OutFmt[10];
   ByTe_1 NeedInt;
   FILE *fd;
   ByTe_4 NSrcs;
   ByTe_4 NAnc;
   ByTe_4 EmptySrc;
   ByTe_1 SrcWns[256];
   void   *Src;
   void   *UDF;
   void   *PIDF;
   void   *SOrder;
};

struct WorkArea
{
   void   *CStore;
   void   *SStore;
   ByTe_4 SizeCStore;
   ByTe_4 NextCStore;
   ByTe_4 SizeSStore;
   ByTe_4 NextSStore;
};
