#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"
#include "Gmenu_var.h"
#include "Util1Ansi.h"
#include "ADump_str.h"
#include "ADump_var.h"
#include "ADump_ansi.h"

int main(int argc, char *argv[])
{
   struct SrcInfo *S, *Sb;
   struct idf_data  *ExDa;

   u_ByTe_2 V;

   ByTe_2 NumSrcs, N, SrcN, End, SrcPos, Rs, MEnd, rN, BegKey = 0;
   ByTe_2 *s1, BegS;

   ByTe_4 R;

   ByTe_1 IsData = 0, GoOn = 1, Fwd;

   InFo.NAnc = 1;

   if (argc == 12)                              /* batch mode                */
   {                                            /* BEG GET TIMES             */
      sscanf(argv[2], "%hd", &BatchTime[0]);    /* begin year                */
      sscanf(argv[3], "%hd", &BatchTime[1]);    /* begin day                 */
      sscanf(argv[4], "%hd", &BatchTime[2]);    /* begin hour                */
      sscanf(argv[5], "%hd", &BatchTime[3]);    /* begin minute              */
      sscanf(argv[6], "%hd", &BatchTime[4]);    /* begin second              */
      sscanf(argv[7], "%hd", &BatchTime[5]);    /* end year                  */
      sscanf(argv[8], "%hd", &BatchTime[6]);    /* end day                   */
      sscanf(argv[9], "%hd", &BatchTime[7]);    /* end hour                  */
      sscanf(argv[10], "%hd", &BatchTime[8]);   /* end minute                */
      sscanf(argv[11], "%hd", &BatchTime[9]);   /* end second                */
   }                                            /* END GET TIMES             */

   ReadMenu (argv[1]); 
   MenuInterface ();  

   /**************************************************************************/
   /* Open up output file if needed                                          */
   /**************************************************************************/

   if (InFo.OutFile[0] == 0)
      InFo.fd = stderr;
   else
   {
      if ((InFo.fd = fopen (InFo.OutFile, "w")) == NULL)
      {
         fprintf (stderr, "CAN'T OPEN OUTPUT FILE %s\n", InFo.OutFile);
         fprintf (stderr, "DEFAULTING TO STDERR");
         InFo.fd = stderr;
      }
   }

   /**************************************************************************/
   /*   Initialize the generic UDF structures                                */
   /*   Establish the PIDF interface structure                               */
   /*   Establish the UDF interface structure                                */
   /*   Report any errors in 5.                                              */
   /**************************************************************************/

   init_udf ();
   CreatePidfStruc (&InFo.PIDF);
   R = create_idf_data_structure (&InFo.UDF);
   ErrorRpt ("MAKE UDF INTERFACE", R, 1);
   get_version_number (&V);

   /**************************************************************************/
   /*   Set pointer to scratch area were all 1 byte stuff is kept            */
   /*   Begin a loop over all defined UDF sources                            */
   /*   Read Source Info from Menu File                                      */
   /**************************************************************************/
   
   End = InFo.NSrcs;
   for (N = 0; N < End; ++N) {                                              
      SrcPos = InFo.EmptySrc;
      MenuOneUdf (N, V);

   /**************************************************************************/
   /*   Set pointer to UDF definition structure                              */
   /*   Get the UDF key                                                      */
   /*   Report any errors in 12.                                             */
   /**************************************************************************/

      GetIt (SrcPos);

   /**************************************************************************/
   /*  Add any additional Sources                                            */
   /**************************************************************************/

      GrowSrcs (SrcPos); 
   }

   /**************************************************************************/
   /*  Get the PIDF Information                                              */
   /**************************************************************************/

   End = InFo.EmptySrc - 1;
   for (N = 0; N <= End; ++N) 
      GetPidfInfo (N);

   SortKeys ();

   /**************************************************************************/
   /*  Set pointer to UDF information structure                              */
   /*  Set pointer to scratch area were all 1 byte stuff is kept             */
   /*  Set pointer to scratch area were all 2 byte stuff is kept             */
   /*  Set pointer to structure holding all read information                 */
   /*  Data Pickup Loop                                                      */
   /**************************************************************************/

   Sb = (struct SrcInfo *)InFo.Src; 
   ExDa = (struct idf_data *) InFo.UDF;
   while (GoOn)
   {

   /**************************************************************************/
   /*  Set pointer to source information structures                          */
   /*  Set pointer to end of source information structures                   */
   /*  Loop over all sources                                                 */
   /*  Get Data                                                              */
   /**************************************************************************/

      while ((NumSrcs = BegEndSrc (BegKey)) > 0)
      {
         BegS = BegKey;                                /* first source       */
         End = NumSrcs - 1;                            /* last source        */
         BegKey = BegKey + NumSrcs;                    /* next key           */

         s1 = (ByTe_2 *)InFo.SOrder + BegS;            /* source order array */
         for (N = 0; N <= End; ++N, ++S) 
         {
            SrcN = *s1++;
            S = Sb + SrcN;
            MEnd = S->TotMCols - 1;
            for (rN = 0; rN <= MEnd; ++rN)
            {
               Fwd = ((rN == MEnd) && (N == End)) ? 1 : 0;
               if (MEnd > 0)
                  S->SenRN = rN;
               Rs = GetData (SrcN, Fwd);
               if (Rs == LOS_STATUS || Rs == EOF_STATUS)
                  GoOn = 0;

               if (ExDa->filled_data == 1)
                  IsData = 1;
            }
         }
      }
      BegKey = 0;

      if (IsData > 0)
      {
         IsData = 0;
         PrData();
         S = (struct SrcInfo *)InFo.Src;
         if (GoOn == 1)
            GoOn = CmpTm (&InFo.TE, &S->Te);
      }
   }

   /**************************************************************************/
   /*  70. Exit Program                                                      */
   /**************************************************************************/

/*
   free_experiment_info();
   */
   exit (0);                                                           /* 70 */
}
