#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "util_var.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"
#include "Gmenu_var.h"
#include "UDFCDF_Var.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Ansi.h"

int main(int argc, char *argv[])
{
   struct SrcInfo *S, *Sb;
   struct idf_data  *ExDa;
   struct experiment_info *ex;
   struct ptr_rec *pTr; 
   struct Pidf *P;

   register ByTe_2 *s1, *sEnD;
   u_ByTe_2 Ver;
   ByTe_2 *Ss;
   ByTe_1 *Cs;

   ByTe_2 N, End, SrcPos, Rs;
   ByTe_2 BegKey = 0, BegS, NumSrcs;

   ByTe_4 R, SrcN, LastCN;
   ByTe_4 Bs, Es;
   ByTe_4 rN = 0;

   ByTe_1 IsData = 0, *X = "", GoOn = 1, Fwd, Mode;
   ByTe_1 NeedFwd;

   InFo.NAnc = 1;
   /**************************************************************************/
   /*   Read in the default menu file                                        */
   /*   Xfer the menu answers to the program structures                      */
   /**************************************************************************/

   if (argc == 12)                              /* batch mode                */
   {                                            /* BEG GET TIMES             */
      sscanf(argv[2], "%hd", &BatchTime[0]);    /* begin year                */
      sscanf(argv[3], "%hd", &BatchTime[1]);    /* begin day                 */
      sscanf(argv[4], "%hd", &BatchTime[2]);    /* begin hour                */
      sscanf(argv[5], "%hd", &BatchTime[3]);    /* begin minute              */
      sscanf(argv[6], "%hd", &BatchTime[4]);    /* begin second              */
      sscanf(argv[7], "%hd", &BatchTime[5]);    /* end year                  */
      sscanf(argv[8], "%hd", &BatchTime[6]);    /* end day                   */
      sscanf(argv[9], "%hd", &BatchTime[7]);    /* end hour                  */
      sscanf(argv[10], "%hd", &BatchTime[8]);   /* end minute                */
      sscanf(argv[11], "%hd", &BatchTime[9]);   /* end second                */
   }                                            /* END GET TIMES             */

   ReadMenu (argv[1]); 
   MenuInterface ();  

   init_udf ();
   CreatePidfStruc (&InFo.PIDF);
   R = create_idf_data_structure (&InFo.UDF);
   ErrorRpt ("MAKE UDF INTERFACE", R, 1);

   /**************************************************************************/
   /*   Set pointer to scratch area were all 1 byte stuff is kept            */
   /*   Begin a loop over all defined UDF sources                            */
   /*   Read Source Info from Menu File                                      */
   /**************************************************************************/
   
   End = InFo.NSrcs;
   get_version_number (&Ver);
   for (N = 0; N < End; ++N) 
   {                                              
      SrcPos = InFo.EmptySrc;
      MenuOneUdf (N);
      Cs = (ByTe_1 *)Wa.CStore;

   /**************************************************************************/
   /*   Set pointer to UDF definition structure                              */
   /*   Get the UDF key                                                      */
   /*   Report any errors in 12.                                             */
   /**************************************************************************/

      S = (struct SrcInfo *)InFo.Src + SrcPos;
      R = get_data_key (Cs + S->P, Cs + S->M, Cs + S->E, Cs + S->I,
                        Cs + S->V, &S->Key);
      ErrorRpt ("UDF KEY", R, 1);                                 

      if (S->OneAll == 3)
         get_version_number (&S->Ver);
      else
         S->Ver = Ver;
      
   /**************************************************************************/
   /*   Compute seconds of day at which to begin getting data                */
   /*   Compute seconds of day at which to end getting data                  */
   /*   Open the appropriate UDF file                                        */
   /*   Report any errors in 16.                                             */
   /**************************************************************************/

      Bs = InFo.TB.Ms / 1000;
      Es = InFo.TE.Ms / 1000;
      Mode = (S->DType == 6) ? 1 : 0;
      R = file_open (S->Key, X, S->Ver, InFo.TB.Yr, InFo.TB.Dy,
                     Bs, 0, InFo.TE.Yr, InFo.TE.Dy, Es, 0, Mode);
      ErrorRpt ("UDF OPEN", R, 1);

   /**************************************************************************/
   /*   Position pointer in UDF file to requested start time                 */
   /*   Report any errors in 18.                                             */
   /*   Check integrity of all UDF memeory                                   */
   /*   Report any errors in 20.                                             */
   /**************************************************************************/

      ReadPidf (S->Key, InFo.PIDF);
      P = (struct Pidf *) InFo.PIDF;

      if (P->Pf.Blocking == 1)
      {
          R = FilePosRec (S->Key, X, S->Ver, InFo.UDF, InFo.TB.Yr,
                          InFo.TB.Dy, Bs, 0, InFo.TE.Yr, InFo.TE.Dy, Es, 0);
      }
      else
      {
          R = file_pos (S->Key, X, S->Ver, InFo.UDF, InFo.TB.Yr,
                          InFo.TB.Dy, Bs, 0, InFo.TE.Yr, InFo.TE.Dy, Es, 0);
      }

      ErrorRpt ("FILE_POS", R, 1);

   /**************************************************************************/
   /*  If this is a matrix sensor get the total number of columns in the     */
   /*  matrix                                                                */
   /**************************************************************************/

      ex = ginfo.expt;
      pTr = ex->info_ptr;
      S->TotMCols = (ex->smp_id == 3 && S->OneAll == 3) ? *pTr->TOT_COLS : 1;

   /**************************************************************************/
   /*  Get the PIDF Information                                              */
   /*  Add any additional Sources                                            */
   /**************************************************************************/

      GetPidfInfo (SrcPos);
      GetVidfInfo (SrcPos);
      GrowSrcs (SrcPos, S->OneAll); 
   }

   if (SortKeys() < 0)
      printf ("Malloc Error in SorKeys\n");
   CDFSetUp();

   /**************************************************************************/
   /*  Set pointer to UDF information structure                              */
   /*  Set pointer to scratch area were all 1 byte stuff is kept             */
   /*  Set pointer to scratch area were all 2 byte stuff is kept             */
   /*  Set pointer to structure holding all read information                 */
   /*  Data Pickup Loop                                                      */
   /**************************************************************************/

   Sb = (struct SrcInfo *)InFo.Src;                    /* pntr to first src  */
   Cs = (ByTe_1 *)Wa.CStore;
   Ss = (ByTe_2 *)Wa.SStore;
   End = InFo.EmptySrc - 1;                            /* last source number */
   sEnD = (ByTe_2 *)InFo.SOrder + End;                 /* end source order   */
   ExDa = (struct idf_data *) InFo.UDF;

   while (GoOn)                                        /* data pickup look   */
   {                                                   /* BEG GET DATA       */
      BegKey = 0;
      while ((NumSrcs = BegEndSrc (BegKey)) > 0)       /* get key group      */
      {                                                /* BEG KEY GROUP      */
         BegS = BegKey;                                /* first source       */
         End = NumSrcs - 1;                            /* last source        */
         BegKey = BegKey + NumSrcs;                    /* next key           */

         s1 = (ByTe_2 *)InFo.SOrder + BegS;            /* source order array */
         for (N = 0; N <= End; ++N)                    /* loop over sources  */
         {
            SrcN = *s1++;                              /* the src number     */
            S = Sb + SrcN;                             /* current source     */
            Fwd = (N == End) ? 1 : 0;                  /* fwd next new src   */
            NeedFwd = Fwd;                             /* set Need To Fwd    */

            if (S->OneAll == 3)                        /* all columns        */
            {                                          /* BEG ALL COL SETS   */
               S->SenCN = 0;                           /* start at beginning */
               Fwd = 0;                                /* no forward         */
            }                                          /* END ALL COL SETS   */

            do                                         /* column loop        */
            {                                          /* BEG COLUMN LOOP    */
               Rs = GetData (SrcN, Fwd);               /* pick up the data   */
               if (S->OneAll == 3 && Rs != 0)          /* all columns?       */
               {                                       /* BEG ALL COL CHK    */
                  LastCN = ExDa->TotCols - 1;          /* last column number */
                  if (LastCN == 0 && NeedFwd)          /* needed forward?    */
                      R = GetData (SrcN, 1);           /* Do forward         */
               }                                       /* END ALL COL CHK    */
               else                                    /* getting one        */
                  LastCN = -1;                         /* make sure          */

               if (ExDa->filled_data == 0)             /* no data picked up  */
               {                                       /* BEG NO DATA        */
                  if (S->OneAll == 3)                  /* all columns        */
                  {                                    /* BEG ALL COL SETS   */
                     ++S->SenCN;                       /* next column        */
                     if (S->SenCN == LastCN && NeedFwd)  /* need to forward? */
                        Fwd = 1;                       /* forward            */
                  }                                    /* END ALL COL SETS   */
                  continue;                            /* to next source     */
               }                                       /* END NO DATA        */
               else                                    /* there was data     */
                  IsData = 1;                          /* set flag           */
   
               if (S->OneAll == 3)                     /* all columns        */
               {                                       /* BEG ALL COL SETS   */
                  ++S->SenCN;                          /* next column        */
                  if (S->SenCN == LastCN && NeedFwd)   /* need to forward?   */
                     Fwd = 1;                          /* forward            */
               }                                       /* END ALL COL SETS   */
   
            } while (S->SenCN <= LastCN);              /* END COLUMN LOOP    */
         }                                             /* END SOURCE LOOP    */

         if (Rs == 0)                                  /* out of data        */
            GoOn = 0;                                  /* no more data       */
         else                                          /* keep on truckin'   */
         {                                             /* BEG STILL DATA     */
            if (GoOn == 1)
            {
               S = (struct SrcInfo *)InFo.Src;         /* pntr to first src  */
               GoOn = CmpTm (&InFo.TE, &S->Te);        /* check for end time */
            }
         }                                             /* BEG STILL DATA     */
      }

      if (IsData > 0)
      {
         if (rN == 0)
         {
            if (CDFSkeleton() < 0)
                printf ("Error creating CDF Skeleton file\n");
            if (CgI.ScanSrc >= 0)
               ScanToCDF (CgI.ScanSrc);
         }
         EpochToCDF (0, rN, "Epoch");
         DataToCDF (0, rN++);
      }
   }                                                   /* END GET DATA       */

   CloseCDF (--rN);
   exit (0);
} 
