#ifndef UDFCDF_STR_H
#define UDFCDF_STR_H

#include <stdio.h>
#include "ByteDefs.h"
#include "cdf.h"

struct CdfGenInfo
{
   ByTe_4 QualSrc;
   ByTe_4 ScanSrc;
};

struct TiMiNg
{
   ByTe_2 Yr;
   ByTe_2 Dy;
   ByTe_4 Ms;
   ByTe_4 Ns;
};

struct SrcInfo
{
   u_ByTe_2 P;                      /* UDF project                          */
   u_ByTe_2 M;                      /* UDF mission                          */
   u_ByTe_2 E;                      /* UDF experiment                       */
   u_ByTe_2 I;                      /* UDF instrument                       */
   u_ByTe_2 V;                      /* UDF virtual instrument               */
   u_ByTe_2 CdfName;                /* CDF varaible name                    */
   u_ByTe_4 Key;                    /* UDF Key                              */
   ByTe_2   DType;                  /* Selected Data Type                   */
   ByTe_2   Group;                  /* Selected Group Number Type           */
   ByTe_2   SenPN;                  /* PIDF SENSOR NUMBER                   */
   ByTe_2   GetPN;                  /* PIDF NUMBER of Item to Get           */
   ByTe_2   GetUN;                  /* PIDF UNIT NUMBER of Item to Get      */
   ByTe_2   AltUN;                  /* PIDF Secondary UNIT NUMBER (Scan)    */
   ByTe_2   SenVN;                  /* VIDF SENSOR NUMBER                   */
   ByTe_2   GetVN;                  /* VIDF NUMBER of Item to Get           */
   ByTe_2   SenCN;                  /* Sensor Matrix COL NUMBER             */
   ByTe_1   GetNAS;                 /* No. of Algorithm Step in Get Units   */
   ByTe_1   Present;                /* Data obtained from last read         */
   ByTe_1   AltNAS;                 /* No. of Algorithm Step in Alt Units   */
   ByTe_1   UDFSrc;                 /* Measurement source in UDF            */
   u_ByTe_2 GetOps;                 /* Scan Operations for Get Units        */
   u_ByTe_2 GetTbls;                /* Tables to apply for Get Units        */
   u_ByTe_2 AltOps;                 /* Scan Operations for Alt Units        */
   u_ByTe_2 AltTbls;                /* Tables to apply for Alt Units        */
   u_ByTe_2 Ver;                    /* Version number                       */
   ByTe_1   OneAll;                 /* Do one or all sensors                */
   ByTe_1   SType;                  /* Sensor Type                          */
   ByTe_1   ScanSca;                /* Scan Scaling                         */
   ByTe_1   RowT;                   /* Sensors are parallel?                */
   ByTe_1   ColT;                   /* data are in parallel?                */
   ByTe_1   AddPh;                  /* add spin phase?                      */
   ByTe_1   AddTh;                  /* add theta?                           */
   ByTe_1   AddSp;                  /* add spin period?                     */
   ByTe_1   AddQ;                   /* add quality?                         */
   ByTe_1   PGet;                   /* get azim per 'C'ol, per 'R'ow, 'A'll */
   ByTe_1   Block;                  /* Block Open?                          */
   void     *Pri;                   /* sensor mesh data                     */
   void     *StartP;                /* sensor start spin phase data         */
   void     *StopP;                 /* sensor stop spin phase data          */
   void     *Alt;                   /* scan data                            */
   ByTe_4   BufSize;                /* buffer size                          */
   ReaL_4   MinValid;               /* minimum valid value                  */
   ReaL_4   MaxValid;               /* maximum valid value                  */
   ReaL_4   Qual;                   /* quality flag                         */
   ReaL_4   SpinPer;                /* Spin Period                          */
   ReaL_4   Theta;                  /* Theta Value                          */
   ByTe_2   DLen;                   /* Number of samples retrieved          */
   ByTe_2   PhLen;                  /* Number of phase samples for CDF      */
   ByTe_2   TotMCols;               /* Number matrix columns in matrix sen  */
   ByTe_4   CDFDim;                 /* CDF dimension                        */
   ByTe_4   CDFDimP;                /* CDF dimension of phase               */
   struct TiMiNg Tb;
   struct TiMiNg Te;
};

struct UserDefs
{
   struct TiMiNg TB;
   struct TiMiNg TE;
   ByTe_1 CdfFile[80];
   ByTe_4 NSrcs;
   ByTe_4 NAnc;
   ByTe_4 EmptySrc;
   ByTe_1 SrcWns[256];
   FILE   *fi;
   FILE   *fo;
   CDFid  CdfId;
   void   *Src;
   void   *UDF;
   void   *PIDF;
   void   *SOrder;
};

struct WorkArea
{
   void   *CStore;
   void   *SStore;
   ByTe_4 SizeCStore;
   ByTe_4 NextCStore;
   ByTe_4 SizeSStore;
   ByTe_4 NextSStore;
};

#endif
