#include <stdlib.h>
#include <stdio.h>

#include "UDFCDF_Str.h"
#include "UDFCDF_Ansi.h"

ByTe_4 TransFer (ByTe_1 *V, ByTe_2 Post, ByTe_2 N) 
{
   extern struct WorkArea Wa;

   register ByTe_1 *c1, *c2, *cEnD;
   register ByTe_2 *s1, *s2, *sEnD;
   
   ByTe_2 Len, Beg;

   if (Post == 1)                                /* text transfer            */
   {                                             /* BEGIN ONE BYTE TRANSFER  */
      Len = (N == 0) ? strlen(V) + 1 : N;        /* length to store          */
      ChkStoreMem (Post, Len);                   /* check memory             */
      Beg = Wa.NextCStore;                       /* start here               */
      c1 = (ByTe_1 *)Wa.CStore + Beg;            /* point to next free byte  */
      cEnD = c1 + Len;                           /* end of data to store     */
      for (c2 = V; c1 < cEnD; )                  /* xfer loop                */
         *c1++ = *c2++;                          /* xfer data                */
      Wa.NextCStore += Len;                      /* next free byte point     */
   }                                             /* END ONE BYTE TRANSFER    */
   else                                          /* TWOBYTE                  */
   {                                             /* BEGIN TWO BYTE TRANSFER  */
      ChkStoreMem (Post, N);                     /* check memory             */
      Beg = Wa.NextSStore;                       /* start here               */
      s1 = (ByTe_2 *)Wa.SStore + Beg;            /* point to next free byte  */
      sEnD = s1 + N;                             /* end of data to store     */
      for (s2 = (ByTe_2*)V; s1 < sEnD; )         /* xfer loop                */
         *s1++ = *s2++;                          /* xfer data                */
      Wa.NextSStore += Len;                      /* next free byte point     */
   }                                             /* END ONE BYTE TRANSFER    */

  return (Beg);                                   /* return pointer to text   */
}
