#include <string.h>
#include "OpSySInD.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

  /**************************************************************************/
  /* Populate A CDF Skeleton file                                           */
  /**************************************************************************/

ByTe_1 SkelLine (ByTe_4 Type, ByTe_4 N, ByTe_1 *SIn, ByTe_4 *DIn, ByTe_4 Rets)
{
   extern struct UserDefs InFo;
   extern struct MeTas CdfMeta;
 
   ByTe_1 FmT[150];

    fgets (FmT, 150, InFo.fi);                      /* Input Format         */
    if (FmT[0] == '*')                              /* Block end character  */
    {                                               /* BEG BLOCK END        */
       fprintf (InFo.fo, "\n");                     /* blank line           */
       return (0);                                  /* return a 0           */
    }                                               /* END BLOCK END        */
    else                                            /* maybe ignore line    */
    {                                               /* BEG IGNORE LINE      */
       if (N < 0)                                   /* no data this line    */
         return (1);                                /* out                  */
    }                                               /* END IGNORE LINE      */
   
    switch (Type)                                   /* Input Type           */
    {                                               /* BEG LINE OUTPUT      */
       case 0:                                      /* START No Input       */
          fprintf (InFo.fo, FmT);                   /* direct copy          */
       break;                                       /* STOP No Input        */
       case 1:                                      /* START String Input   */
          fprintf (InFo.fo, FmT, SIn);              /* print string         */
       break;                                       /* STOP String Input    */
       case 3:                                      /* START VAR/ATT etc    */
          fprintf (InFo.fo, FmT, DIn[0], DIn[1],    /* print values         */
                 DIn[2], DIn[3], DIn[4], DIn[5]);
       break;                                       /* STOP VAR/ATT etc     */
       case 5:                                      /* START Num/Str Input  */
          fprintf (InFo.fo, FmT, N, SIn);           /* print string         */
       break;                                       /* STOP Num/Str Input   */
    }                                               /* END LINE OUTPUT      */

    while (Rets-- > 0)                              /* Add Blank Lines      */
      fprintf (InFo.fo, "\n");                      /* blank line           */

    return (1);
}
