#include <string.h>

#include "OpSySInD.h"
#include <stdlib.h>

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

void ScanToCDF (ByTe_4 N)
{
   extern struct UserDefs InFo;

   struct SrcInfo *S;

   void *Edges;

   register float *F1;
   CDFstatus rV;
   long dInd[1], dSz[1], dInt[1];

   S = (struct SrcInfo *)InFo.Src + N; 

   /*************************************************************************/
   /* Write Down Centers                                                    */
   /*************************************************************************/

   dInd[0] = 0;
   dSz[0] = (long) S->DLen;
   dInt[0] = 1;
   F1 = (float *)S->Alt;
   rV = CDFlib (SELECT_, zVAR_NAME_, "Center_Scan", zVAR_RECNUMBER_, 0,
                zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, zVAR_DIMINDICES_, 
                dInd, zVAR_DIMCOUNTS_, dSz, zVAR_DIMINTERVALS_, dInt, PUT_, 
                zVAR_HYPERDATA_, F1, NULL_);

   if (rV != CDF_OK)
   {
      printf ("CDFlib error processing center scan\n");
      exit(-1);
   }

   ScanEdges (&Edges, N);
   F1 = (float *)Edges;
   rV = CDFlib (SELECT_, zVAR_NAME_, "Lower_Bin_Edge", zVAR_RECNUMBER_, 0,
                zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, zVAR_DIMINDICES_, 
                dInd, zVAR_DIMCOUNTS_, dSz, zVAR_DIMINTERVALS_, dInt, PUT_, 
                zVAR_HYPERDATA_, F1, NULL_);
   if (rV != CDF_OK)
   {
      printf ("CDFlib error processing lower scan edges\n");
      exit(-1);
   }

   F1 = (float *)Edges + S->DLen;
   rV = CDFlib (SELECT_, zVAR_NAME_, "Upper_Bin_Edge", zVAR_RECNUMBER_, 0,
                zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, zVAR_DIMINDICES_, 
                dInd, zVAR_DIMCOUNTS_, dSz, zVAR_DIMINTERVALS_, dInt, PUT_, 
                zVAR_HYPERDATA_, F1, NULL_);
   if (rV != CDF_OK)
   {
      printf ("CDFlib error processing upper scan edges\n");
      exit(-1);
   }

   free (Edges);
}
