#include <stdio.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "util_var.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "libCfg.h"

#include "UDFCDF_Str.h"
#include "UDFCDF_Ansi.h"

ByTe_2 GetData (ByTe_2 N, ByTe_1 FwD)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern struct general_info ginfo;

   struct experiment_info *ex;
   struct ptr_rec *pTr; 

   struct SrcInfo *S;
   struct idf_data  *ExDa;

   ReaL_4 *f1, *f2, *f3, *f4, *fEnD;
   ByTe_4 sS, nS;
   ByTe_2 *Ss, R, Rs, rN;
   ByTe_1 *Cs;
   ByTe_1 *X = "";

   S = (struct SrcInfo *)InFo.Src + N;
   S->Present = 0;
   Cs = (ByTe_1 *)Wa.CStore;
   Ss = (ByTe_2 *)Wa.SStore;
   ExDa = (struct idf_data *) InFo.UDF;

   Rs = read_drec (S->Key, X, S->Ver, InFo.UDF, S->SenVN, S->SenCN, FwD, 0);
   ErrorRpt ("READ_DREC", Rs, 0);

   ex = ginfo.expt;
   pTr = ex->info_ptr;

   S->TotMCols = (ex->smp_id == 3 && S->OneAll == 3) ? *pTr->TOT_COLS : 1;

   if (Rs == ALL_OKAY || ExDa->filled_data)
   {
      CheckMem (N);
      S->Present = 1;

   /**************************************************************************/
   /*  Switch on the type of data which is being requested                   */
   /*                                                                        */
   /*  0: Sensor                                                             */
   /*  1: Scan                                                               */
   /*  2: Ancillary                                                          */
   /*  3: Spin Angle                                                         */
   /*  4: Pitch Angle                                                        */
   /*  5: Quality                                                            */
   /*  6: Mode                                                               */
   /**************************************************************************/

      switch (S->UDFSrc) 
      {
         case 0: 
           rN = (S->TotMCols == 1) ? 0 : (S->OneAll == 3) ? S->SenCN : 0;
           f1 = (ReaL_4 *)S->Pri + rN * ExDa->num_sample;
           R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, 
                                SENSOR, 0, S->GetNAS, Cs + S->GetTbls,  
                                Ss + S->GetOps, f1, 0, 0L);
           ErrorRpt ("CONVERT_TO_UNITS", R, 1);
           S->DLen  = ExDa->num_sample;

         case 1:
            if (S->AltUN >= 0)
              GetAlt (N);
          break;

         case 2:
            if (InFo.NAnc < *(ex->CSET_NUM + S->GetVN))
               InFo.NAnc = *(ex->CSET_NUM + S->GetVN);
            rN = (S->TotMCols == 1) ? 0 : S->SenCN;
            f1 = (ReaL_4 *)S->Pri + rN * ExDa->num_sample;
            R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, 
                           ANCILLARY, S->GetVN, S->GetNAS, Cs + S->GetTbls,  
                             Ss + S->GetOps, f1, 0, 0L);
            ErrorRpt ("CONVERT_TO_UNITS", R, 1);
            S->DLen  = ExDa->num_sample;

            if (S->AltUN >= 0)
               GetAlt (N);
         break;

         case 6: 
           f1 = (ReaL_4 *)S->Pri;
           R = convert_to_units (S->Key, X, S->Ver, InFo.UDF, 
                                MODE, S->GetVN, S->GetNAS, Cs + S->GetTbls,  
                                Ss + S->GetOps, f1, 0, 0L);
           ErrorRpt ("CONVERT_TO_UNITS", R, 1);
           S->DLen  = 1;

          break;

      }

      S->Qual = ExDa->d_qual;
      S->SpinPer = ExDa->spin_rate;

      if (S->AddPh)
      {
         f1 = (ReaL_4 *)S->StartP;
         f2 = (ReaL_4 *)S->StopP;
         f3 = (ReaL_4 *)ExDa->start_az;
         f4 = (ReaL_4 *)ExDa->stop_az;
         fEnD = f3 + ExDa->num_sample;
         switch (S->CDFDimP)
         {
            case 0:
               *f1 = *f3;
               *f2 = *f4;
               S->PhLen = 1;
            break;
            case 1:
               if (S->SType == 1 || (S->SType == 3 && S->PGet == 'R')) 
               {
                  S->PhLen = S->DLen;
                  for ( ; f3 < fEnD; )
                  {                  
                     *f1++ = *f3++; 
                     *f2++ = *f4++;
                  }               
               }
               else
               {
                  S->PhLen = S->TotMCols;
                  f1 += rN;
                  f2 += rN;
                  *f1 = *f3;
                  *f2 = *f3;
               }
            break;
            case 2:
               S->PhLen = S->DLen;
               f1 += rN * ExDa->num_sample;
               f2 += rN * ExDa->num_sample;
               for ( ; f3 < fEnD; )
               {                  
                  *f1++ = *f3++; 
                  *f2++ = *f4++;
               }               
            break;
         }
      }

      if ((ex->smp_id == 3 && S->OneAll == 3 && S->SenCN == 0) ||
           ex->smp_id != 3 || (ex->smp_id == 3 && S->OneAll != 3))
      {
         S->Tb.Yr = ExDa->byear;
         S->Tb.Dy = ExDa->bday;
         S->Tb.Ms = ExDa->bmilli;
         S->Tb.Ns = ExDa->bnano;
      }

      S->Te.Yr = ExDa->eyear;
      S->Te.Dy = ExDa->eday;
      S->Te.Ms = ExDa->emilli;
      S->Te.Ns = ExDa->enano;
   }

   if (FwD == 1)
   {
      sS = (InFo.TE.Ms + (InFo.TE.Ns / 1000000)) / 1000;
      nS = (InFo.TE.Ms % 1000) * 1000000 + InFo.TE.Ns;
      Rs = ReOpenFile (S->Key, X, S->Ver, InFo.UDF, 0, 0, 0, 0,
                       InFo.TE.Yr, InFo.TE.Dy, sS, nS, Rs); 
      ErrorRpt ("REOPENFILE", Rs, 0);
   }

   ginfo.called_locate = 0;
   return (Rs);
}
