/****************************************************************************/
/*  This routine spits out any error messages                               */
/****************************************************************************/

#include <stdio.h>
#include "user_defs.h"
#include "ret_codes.h"
#include "UDFCDF_Ansi.h"

void ErrorRpt (ByTe_1 *From, ByTe_2 Error, ByTe_1 Type)
{
   if (Error != ALL_OKAY)
   {
      switch (Type)
      {
         case 0:
            if (Error < EOF_STATUS)
            {
               fprintf (stderr, "ERROR FROM %s: No. %d\n", From, Error);
               exit (-1);
            }
         break;

         case 1:
            if (Error != ALL_OKAY)
            {
              fprintf (stderr, "ERROR FROM %s: No. %d\n", From, Error);
              exit (-1);
            }
         break;

         case 2:
            fprintf (stderr, "MALLOC OR REALLOC ERROR in %s\n", From);
            exit (-1);
         break;
     }
  }
}
