#include <string.h>
#include <stdlib.h>
#include "OpSySInD.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

#define EMPTY (ByTe_1 *)0


ByTe_1 EpochSkel ()
{
   extern struct UserDefs InFo;

   struct SrcInfo *S;
   FILE *fi;

   ByTe_4 Var[10]; 
   ByTe_1 dV[1];
   ByTe_1 SName[150];
   ByTe_1 *Fs = PathSep;

   sprintf(SName,"%s%sUDFToCDF%sZVAREPOCH.skt",getenv("UDFTOOL_HOME"), Fs, Fs);
   S = (struct SrcInfo *)InFo.Src; 

  /**************************************************************************/
  /* Open a the generic ZVAR EPOCH skeleton file                            */
  /**************************************************************************/

   if ((fi = fopen (SName, "r")) == NULL)
      return (-1);

   Var[0] = 0;
   dV[0] = 'F';

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 1    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 2    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarFmt ("Epoch", "CDF_EPOCH", 1, 0, Var, 'T', dV);  /* variable def     */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 1 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 2 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarLine (fi, 1, 1, "Time Line", 0.0, 0);            /* FIELDNAM         */
   ZVarLine (fi, 2, 1, EMPTY, 0.0, 0);                  /* VALIDMIN         */
   ZVarLine (fi, 3, 1, EMPTY, 0.0, 0);                  /* VALIDMAX         */
   ZVarLine (fi, 2, 1, EMPTY, 0.0, 0);                  /* SCALEMIN         */
   ZVarLine (fi, 3, 1, EMPTY, 0.0, 0);                  /* SCALEMAX         */
   ZVarLine (fi, 1, 1, "linear", 0.0, 0);               /* SCAPETYP         */
   ZVarLine (fi, 1, 1, "Epoch", 0.0, 0);                /* LABELAXIS        */
   ZVarLine (fi, 1, 1, "ms", 0.0, 0);                   /* UNITS            */
   ZVarLine (fi, 1, 1, "E14.8", 0.0, 0);                /* FORMAT           */
   ZVarLine (fi, 1, 1, "Epoch_Start", 0.0, 0);          /* DELTA_PLUS_VAR   */
   ZVarLine (fi, 1, 1, "Epoch_Start", 0.0, 0);          /* DELTA_MINUS_VAR  */
   ZVarLine (fi, 1, 1, "INCREASE", 0.0, 0);             /* MONOTON          */
   ZVarLine (fi, 1, 1, "Start Time for the record", 0.0, 0);  
   ZVarLine (fi, 1, 1, "-1.0e31", 0.0, 0);              /* FILLVAL          */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DICT_KEY         */
   ZVarLine (fi, 1, 1, "support_data", 0.0, 0);         /* VAR_TYPE         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* AVG_TYPE         */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DISPLAY_TYPE     */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_input      */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_software   */
   ZVarLine (fi, 1, 1, "scalar>na", 0.0, 0);            /* FRAME            */
   ZVarLine (fi, 1, 1, "1", 0.0, 0);                    /* SC_id            */
   ZVarLine (fi, 1, 1, "10", 0.0, 0);                   /* Sig_digits       */
   ZVarLine (fi, 1, 1, "na", 0.0, 1);                   /* SI_conversion    */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_0         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_1         */

   fclose (fi);

  /**************************************************************************/
  /* Open a the generic ZVAR DOUBLE skeleton file (EPOCH-START)             */
  /**************************************************************************/

   sprintf(SName,"%s%sUDFToCDF%sZVARDOUBLE.skt",getenv("UDFTOOL_HOME"), Fs, Fs);
   if ((fi = fopen (SName, "r")) == NULL)
      return (-1);

   Var[0] = 0;
   dV[0] = 'F';

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 1    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 2    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarFmt ("Epoch_Start", "CDF_REAL8", 1, 0, Var, 'T', dV);  /* var def    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 1 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 2 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarLine (fi, 1, 1, "Time Resolution", 0.0, 0);      /* FIELDNAM         */
   ZVarLine (fi, 1, 1, "0.0", 0.0, 0);                  /* VALIDMIN         */
   ZVarLine (fi, 1, 1, "3.162240e+10", 0.0, 0);         /* VALIDMAX         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* SCALEMIN         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* SCALEMAX         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* SCAPETYP         */
   ZVarLine (fi, 1, 1, "dt", 0.0, 0);                   /* LABELAXIS        */
   ZVarLine (fi, 1, 1, "ms", 0.0, 0);                   /* UNITS            */
   ZVarLine (fi, 1, 1, "E14.8", 0.0, 0);                /* FORMAT           */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_PLUS       */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_MINUS      */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* MONOTON          */
   ZVarLine (fi, 1, 1, "Start Time = Epoch - value", 0.0, 0);  
   ZVarLine (fi, 1, 1, "-1.0e31", 0.0, 0);              /* FILLVAL          */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DICT_KEY         */
   ZVarLine (fi, 1, 1, "support_data", 0.0, 0);         /* VAR_TYPE         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* AVG_TYPE         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DISPLAY_TYPE     */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_input      */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_S/W        */
   ZVarLine (fi, 1, 1, "scalar>na", 0.0, 0);            /* FRAME            */
   ZVarLine (fi, 1, 1, "1", 0.0, 0);                    /* SC_id            */
   ZVarLine (fi, 1, 1, "10", 0.0, 0);                   /* Sig_digits       */
   ZVarLine (fi, 1, 1, "1.0e-3>s", 0.0, 1);             /* SI_conver        */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_0         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_1         */

   fclose (fi);

  /**************************************************************************/
  /* Open a the generic ZVAR DOUBLE skeleton file (EPOCH-START)             */
  /**************************************************************************/

   if ((fi = fopen (SName, "r")) == NULL)
      return (-1);

   Var[0] = 0;
   dV[0] = 'F';

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 1    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 2    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarFmt ("Epoch_End", "CDF_REAL8", 1, 0, Var, 'T', dV);  /* var def      */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 1 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 2 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarLine (fi, 1, 1, "Time Resolution", 0.0, 0);      /* FIELDNAM         */
   ZVarLine (fi, 1, 1, "0.0", 0.0, 0);                  /* VALIDMIN         */
   ZVarLine (fi, 1, 1, "3.162240e+10", 0.0, 0);         /* VALIDMAX         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* SCALEMIN         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* SCALEMAX         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* SCAPETYP         */
   ZVarLine (fi, 1, 1, "dt", 0.0, 0);                   /* LABELAXIS        */
   ZVarLine (fi, 1, 1, "ms", 0.0, 0);                   /* UNITS            */
   ZVarLine (fi, 1, 1, "E14.8", 0.0, 0);                /* FORMAT           */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_PLUS       */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_MINUS      */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* MONOTON          */
   ZVarLine (fi, 1, 1, "End Time = Epoch + value", 0.0, 0);  
   ZVarLine (fi, 1, 1, "-1.0e31", 0.0, 0);              /* FILLVAL          */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DICT_KEY         */
   ZVarLine (fi, 1, 1, "support_data", 0.0, 0);         /* VAR_TYPE         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* AVG_TYPE         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DISPLAY_TYPE     */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_input      */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_S/W        */
   ZVarLine (fi, 1, 1, "scalar>na", 0.0, 0);            /* FRAME            */
   ZVarLine (fi, 1, 1, "1", 0.0, 0);                    /* SC_id            */
   ZVarLine (fi, 1, 1, "10", 0.0, 0);                   /* Sig_digits       */
   ZVarLine (fi, 1, 1, "1.0e-3>s", 0.0, 0);             /* SI_conver        */
   ZVarLine (fi, 1, 1, "Epoch", 0.0, 1);                /* DEPEND_0         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_1         */

   fclose (fi);
   return (1);
}
