#include <string.h>

#include "OpSySInD.h"
#include <stdlib.h>

#include "user_defs.h"
#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

void DataToCDF (ByTe_4 N, ByTe_4 rN)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct SrcInfo *S;
   register ByTe_2 *s1;

   ByTe_4 I, End;
   ByTe_1 Name[80], *Cs;

   register float *F1;
   CDFstatus rV;
   long dInd[2], dSz[2], dInt[2];
   float Fd[2];

   S = (struct SrcInfo *)InFo.Src; 

   End = InFo.EmptySrc - 1;                            /* last source number */
   s1 = (ByTe_2 *)InFo.SOrder;                         /* source order array */
   Cs = (ByTe_1 *)Wa.CStore;

   for (I = 0; I <= End; ++I)                          /* loop over sources  */
   {
      S = (struct SrcInfo *)InFo.Src + *s1++; 
      if (S->Present == 0)
      {
         if (S->CDFDim == 0)
            F1 = (float *)Fd;
         else
            return;

         *F1 = OUTSIDE_MIN;
      }
      else
         F1 = (float *)S->Pri;
       
   /*************************************************************************/
   /* Write Down Data                                                       */
   /*************************************************************************/

      dInd[0] = 0;
      dInt[0] = 1;
      dSz[0] = (S->CDFDim > 0 ) ? (long) S->DLen : 1;
      if (S->CDFDim == 2 )
      {
         dInd[1] = 0;
         dInt[1] = 1;
         dSz[0] = S->TotMCols;
         dSz[1] = S->DLen;
      }

      rV = CDFlib (SELECT_, zVAR_NAME_, Cs + S->CdfName, zVAR_RECNUMBER_, 
                   (long)rN, zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, 
                   zVAR_DIMINDICES_, dInd, zVAR_DIMCOUNTS_, dSz, 
                   zVAR_DIMINTERVALS_, dInt, PUT_, zVAR_HYPERDATA_, F1, NULL_);

      if (rV != CDF_OK)
      {
         printf ("CDFlib error processing THE DATA\n");
         exit(-1);
      }

      if (S->AddPh == 1)
      {
         sprintf (Name, "Beg_Phase_%s", Cs + S->CdfName);
      
         dInd[0] = 0;
         dInt[0] = 1;
         dSz[0] = (S->CDFDimP > 0 ) ? (long) S->PhLen : 1;
         if (S->CDFDimP == 2 )
         {
            dInd[1] = 0;
            dInt[1] = 1;
            dSz[1] = S->TotMCols;
         }
         F1 = (float *)S->StartP;

         rV = CDFlib (SELECT_, zVAR_NAME_, Name, zVAR_RECNUMBER_, (long)rN,
                    zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, zVAR_DIMINDICES_, 
                    dInd, zVAR_DIMCOUNTS_, dSz, zVAR_DIMINTERVALS_, dInt, PUT_, 
                    zVAR_HYPERDATA_, F1, NULL_);

         if (rV != CDF_OK)
         {
            printf ("CDFlib error processing THE DATA\n");
            exit(-1);
         }

         sprintf (Name, "End_Phase_%s", Cs + S->CdfName);
         F1 = (float *)S->StopP;

         rV = CDFlib (SELECT_, zVAR_NAME_, Name, zVAR_RECNUMBER_, (long)rN,
                   zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, zVAR_DIMINDICES_, 
                   dInd, zVAR_DIMCOUNTS_, dSz, zVAR_DIMINTERVALS_, dInt, PUT_, 
                   zVAR_HYPERDATA_, F1, NULL_);

         if (rV != CDF_OK)
         {
            printf ("CDFlib error processing THE DATA\n");
            exit(-1);
         }
      }

      if (S->AddSp == 1)
      {
         sprintf (Name, "Spin_Period");
      
         dInd[0] = 0;
         dInt[0] = 1;
         dSz[0] = 1;
         Fd[0] = S->SpinPer;
         F1 = Fd;

         rV = CDFlib (SELECT_, zVAR_NAME_, Name, zVAR_RECNUMBER_, (long)rN,
                    zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, zVAR_DIMINDICES_, 
                    dInd, zVAR_DIMCOUNTS_, dSz, zVAR_DIMINTERVALS_, dInt, PUT_, 
                    zVAR_HYPERDATA_, F1, NULL_);

         if (rV != CDF_OK)
         {
            printf ("CDFlib error processing THE DATA\n");
            exit(-1);
         }
      }
      
      if (S->AddQ == 1)
      {
         sprintf (Name, "DQual_%s", Cs + S->CdfName);
      
         dInd[0] = 0;
         dInt[0] = 1;
         dSz[0] = 1;
         Fd[0] = S->Qual;
         F1 = Fd;

         rV = CDFlib (SELECT_, zVAR_NAME_, Name, zVAR_RECNUMBER_, (long)rN,
                    zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, zVAR_DIMINDICES_, 
                    dInd, zVAR_DIMCOUNTS_, dSz, zVAR_DIMINTERVALS_, dInt, PUT_, 
                    zVAR_HYPERDATA_, F1, NULL_);

         if (rV != CDF_OK)
         {
            printf ("CDFlib error processing THE DATA\n");
            exit(-1);
         }
      }

      if (S->AddTh == 1)
      {
         sprintf (Name, "Theta_%s", Cs + S->CdfName);
      
         dInd[0] = 0;
         dInt[0] = 1;
         dSz[0] = 1;
         Fd[0] = S->Theta;
         F1 = Fd;

         rV = CDFlib (SELECT_, zVAR_NAME_, Name, zVAR_RECNUMBER_, (long)rN,
                    zVAR_RECCOUNT_, 1, zVAR_RECINTERVAL_, 1, zVAR_DIMINDICES_, 
                    dInd, zVAR_DIMCOUNTS_, dSz, zVAR_DIMINTERVALS_, dInt, PUT_, 
                    zVAR_HYPERDATA_, F1, NULL_);

         if (rV != CDF_OK)
         {
            printf ("CDFlib error processing THE DATA\n");
            exit(-1);
         }
      }
   }
}
