/**************************************************************************/
/*  This routine figures out what needs to be malloced and how many bytes */
/*  to allocate for each item                                             */
/**************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "UDFCDF_Str.h"
#include "util_str.h"
#include "user_defs.h"
#include "libbase_udf.h"
#include "UDFCDF_Ansi.h"

void CheckMem (ByTe_4 N)
{
   extern struct UserDefs InFo;

   struct idf_data  *ExDa;
   struct SrcInfo *S;

   ByTe_4 B;
   ByTe_2 LenA, LenB, LenC;

   /**************************************************************************/
   /* Set pointer to the structure which holds all the information which     */
   /* was obtained in the read.                                              */
   /**************************************************************************/

   ExDa = (struct idf_data *) InFo.UDF;              /* ptr to data          */
   S = (struct SrcInfo *) InFo.Src + N;              /* source structure     */

   if (S->OneAll == 3)                               /* all matrix columns   */
      LenA = S->TotMCols * ExDa->num_sample;         /* pri scan length      */
   else                                              /* just one reads worth */
      LenA = ExDa->num_sample;                       /* pri scan length      */

   LenB = 3 * ExDa->num_sample;                      /* alt scan length      */

   if (S->AddPh == 1)
   {
      switch (S->CDFDimP)
      {
         case 0:
            LenC = 1;
         break;
         case 1:
            if (S->SType == 1 || (S->SType == 3 && S->PGet == 'R')) 
               LenC = ExDa->num_sample;
            else
               LenC = S->TotMCols;
         break;
         case 2:
            LenC = ExDa->num_sample * S->TotMCols;
         break;
      }
   }
   else
      LenC = 0;

   if (LenA > S->BufSize)                            /* not enough memory?   */
   {
      B = LenA * sizeof (ReaL_4);                    /* bytes for data store */
      if ((S->Pri = realloc(S->Pri, B)) == 0)        /* mem for Sensor data  */
         ErrorRpt ("CheckMem", 0, 2);                /* oops - error bye     */
      B = LenB * sizeof (ReaL_4);                    /* bytes for alt store  */
      if ((S->Alt = realloc(S->Alt, B)) == 0)        /* mem for Scan data    */
         ErrorRpt ("CheckMem", 0, 2);                /* oops - error bye     */

      if (LenC > 0)
      {
         B = LenC * sizeof (ReaL_4);                 /* bytes for alt store  */
         if ((S->StartP = realloc(S->StartP, B)) == 0)  /* mem for Scan data */
            ErrorRpt ("CheckMem", 0, 2);             /* oops - error bye     */
         if ((S->StopP = realloc(S->StopP, B)) == 0)  /* mem for Scan data   */
            ErrorRpt ("CheckMem", 0, 2);             /* oops - error bye     */
      }

      S->BufSize = LenA;                             /* new buffer size      */
   }
}
