#include <string.h>

#include "OpSySInD.h"
#include <time.h>
#include <stdlib.h>

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

  /**************************************************************************/
  /* Populate A CDF Skeleton file                                           */
  /**************************************************************************/

ByTe_1 CDFSkeleton (void)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct tm *MyTm;
   struct SrcInfo *S;

   time_t Sec;
   ByTe_1 *TimeStr, *CleanStr;

   int rV, fc;
   ByTe_4 Var[10], I, L; 
   ByTe_2 Yr, Dy, Hr, Mn, Sc; 
   ByTe_1 CdfFName[256], SName[150];
   ByTe_1 MiscStr[80];
   ByTe_1 *Fs = PathSep, *Cs;
   ByTe_1 Cmd[150];

   CDFid IdCdf;
   CDFstatus status;

   sprintf (SName, "%s%sUDFToCDF%sRawCDF.skt", getenv("UDFTOOL_HOME"), Fs, Fs);

   S = (struct SrcInfo *)InFo.Src; 
   Cs = Wa.CStore;

  /**************************************************************************/
  /* Open a blank CDF skeleton file                                         */
  /**************************************************************************/

   if ((InFo.fi = fopen (SName, "r")) == NULL)
      return (-1);

  /**************************************************************************/
  /* Ferret out a name to give to this CDF file.  As a first try give it    */
  /* MISSION with the requested start time appended to it.  Tacit           */
  /* assumption is that all of the data comes from the same MISSION.        */
  /**************************************************************************/

   Yr = InFo.TB.Yr;
   Dy = InFo.TB.Dy;
   Hr = InFo.TB.Ms / 3600000;
   Mn = InFo.TB.Ms % 3600000 / 60000;
   Sc = ((InFo.TB.Ms % 3600000) % 60000) / 1000;

   sprintf (CdfFName,"%s_%04d%03d%02d%02d%02d_V1",Cs+S->V, Yr, Dy, Hr, Mn, Sc);
   strcpy (InFo.CdfFile, CdfFName);

   if ((InFo.fo = fopen ("UDFCDF.skt","w")) == NULL)
      return (-1);

  /**************************************************************************/
  /* Set the creation time to the current local time                        */
  /**************************************************************************/

   Sec = time ((time_t *)0);
   MyTm = localtime(&Sec);
   TimeStr = asctime (MyTm);
   CleanStr = strrchr (TimeStr, '\n');
   if (CleanStr != NULL)
     *CleanStr = '\0';

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   SkelLine (1, 1, InFo.CdfFile, (ByTe_4 *)0, 0);      /* File name comment */
   SkelLine (1, 1, TimeStr, (ByTe_4 *)0, 0);           /* Generated comment */
   SkelLine (2, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* version comment   */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* creator comment   */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 2);       /* #header           */
   SkelLine (1, 1, InFo.CdfFile, (ByTe_4 *)0, 0);      /* CDF NAME          */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* DATA ENCODING     */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* MAJORITY          */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* FORMAT            */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Var/Att/Rec Line  */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Underlines        */

   CDFVarCnt (Var);

   SkelLine (3, 1, (ByTe_1 *)0, Var, 2);               /* Var/Att/Rec/Dim   */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Globals Line      */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Attribs Line 1    */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Attribs Line 2    */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Underlines        */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Dicipline Line 1  */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Dicipline Line 2  */

   CDFSource (0);                                      /* give UDF sources  */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Data Version      */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* ADID Reference    */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Data Type         */
   SkelLine (1, 1, InFo.CdfFile, (ByTe_4 *)0, 1);      /* CDF File name     */
   while (SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0));  /* References     */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Generated By      */

   sprintf (MiscStr, "%d-%02d-%02dT%02d:%02d:%02d.000Z",
             MyTm->tm_year+1900, MyTm->tm_mon+1, MyTm->tm_mday, 
             MyTm->tm_hour, MyTm->tm_min, MyTm->tm_sec);
   SkelLine (1, 1, MiscStr, (ByTe_4 *)0, 1);           /* Generated Date    */

   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Validate          */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Rules of Use      */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Acknowledgement   */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Parents           */

   CDFGAttSrcs();                                      /* More Source Info  */

   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Skeleton Version  */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Software Version  */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Validator         */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* Validity          */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Data Intervals    */

   CDFGAttUDF();                                       /* UDF Global Attrib */

   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Var Attributes    */
   for (I = 0; I < 25; ++I)                            /* Var Attribs Loop  */
      SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);    /* Var Attribute     */
   L = (S->SType != 2) ? 1 : -1;                       /* Scan Varaibles?   */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* Var Attribute     */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* #variables        */
   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 1);       /* #Zvariables       */

   EpochSkel();                                        /* Time zVar         */
   UDFSkel();                                          /* Data zVar         */

   SkelLine (0, 1, (ByTe_1 *)0, (ByTe_4 *)0, 0);       /* #end              */

   fclose (InFo.fo);                                   /* shut new skeleton */
   fclose (InFo.fi);                                   /* shut skt template */

   strcat (CdfFName, ".cdf");
   if ((fc = open (CdfFName, 0)) >= 0)
     unlink (CdfFName);

   strcpy (MiscStr, "skeletoncdf -fillval -neg2posfp UDFCDF");
   sprintf (Cmd, "%s%s%s", getenv("CDF_BIN"), Fs, MiscStr);
   rV = system (Cmd);
 
   if ((fc = open (CdfFName, 0)) <= 0)
   {
      printf ("Drat! Drat! Drat! - No CDF Skeleton file produced!"); 
      exit (-1);
   }

   status = CDFopen (InFo.CdfFile, &IdCdf);
   if (status != CDF_OK)
   {
      printf ("Hmmmm! - Can't open CDF file just created!"); 
      exit (-1);
   }
   InFo.CdfId = IdCdf;

   return (1);
}
