#include <string.h>
#include "OpSySInD.h"
#include <stdio.h>
#include "util_str.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "libbase_udf.h"
#include "local_defs.h"
#include "ret_codes.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

/*****************************************************************************/
/* ISTP required Source Global Attributes                                    */
/*****************************************************************************/

void CDFGAttSrcs ()
{
    extern struct UserDefs InFo;
    extern struct WorkArea Wa;

    struct SrcInfo *S;

    register ByTe_1 *c1;

    ByTe_2 R;
    ByTe_1 *Cs;
    ByTe_1 FmT[640], MiscStr[410];

    S = (struct SrcInfo *)InFo.Src;
    Cs = (ByTe_1 *)Wa.CStore;

    fgets (FmT, 150, InFo.fi);                            /* Input Format    */
    sprintf (MiscStr, "%s_MD_%s", Cs + S->P , Cs + S->M); /* Project Mission */
    fprintf (InFo.fo, FmT, MiscStr);                      /* Logical Source  */
    fgets (&FmT[80], 150, InFo.fi);                       /* Input Format    */
    fprintf (InFo.fo, &FmT[80]);                          /* Logical SrcDesc */
    fgets (&FmT[160], 150, InFo.fi);                      /* Input Format    */
    sprintf (MiscStr, "%s, %s", Cs + S->P, Cs + S->E);    /* Proj / Exper    */
    fprintf (InFo.fo, &FmT[160], MiscStr);                /* Logical Source  */
    fgets (&FmT[240], 150, InFo.fi);                      /* Input Format    */
    fprintf (InFo.fo, &FmT[240]);                         /* Mission Group   */
    fgets (&FmT[320], 150, InFo.fi);                      /* Input Format    */
    fprintf (InFo.fo, &FmT[320]);                         /* Inst Type       */

    R = read_idf (S->Key, "", S->Ver, MiscStr, _ContacT, 0, 0, 1);
    ErrorRpt ("CDFGATTISTP", R, 0);
    c1 = TrimString (MiscStr);
    fgets (&FmT[400], 150, InFo.fi);                      /* Input Format    */
    fprintf (InFo.fo, &FmT[400], c1);                     /* PI Name         */
    c1 = TrimString (&MiscStr[81]);
    fgets (&FmT[480], 150, InFo.fi);                      /* Input Format    */
    fprintf (InFo.fo, &FmT[480], c1);                     /* PI Affiliation  */

    fgets (&FmT[560], 150, InFo.fi);                      /* Input Format    */
    fprintf (InFo.fo, &FmT[560]);                         /* Time Res        */
    fprintf (InFo.fo, "\n");                              /* And a Blank     */
}
