#!/usr/bin/env python

import depwi

# Below is the first record from: 
#
#  /opt/project/de/data/lowrate/uncalibrated/1981/pwi81314.dat

sRec1 = 'cc\x00\x00\xa1=\x01\x00\x116&\x05\x01\x00\x00\x00\x10\x00\x00\x00\xdd\x00\x00\x00A\x00\x00\x00\x00\x00\x00\x00F\x04B\x00\xfc\x00\x00\x00\xc7\x00\x00\x00\xa6\x00\x00\x00\xff\xff\x8a\x003A\x00\x00a\xe9\xff\xff2<\x00\x00 \xf4\xa1\r\xb3g\t\x00\x83\x1b\x11\x00\xee#\x01\x00B\xc7\x01\x00F"\x0b\x007\x00\x00\x00\'\x00\x00\x00\xf2\xff\xff\xff\xdc\xff\xff\xff\xa0\xcb4\x00z#\x00\x00\t\xf4\xff\xff$\x0b\x00\x00\x88\n\x00\x00]\xfc\xff\xff\x8f\xda\xff\xff\x82\x0c\x00\x00\x02%\x00\x00\xec\xff\xff\xffH\x10 \xf8|\xf5\xaf\x02\x006O\x0f\x0bN\x00\x00\x03\x0f\x00\x002<\x00\x00\x9d\xe5\xff\xff\x93\xe5\xff\xff\x8b\xf4\xff\xff\xb9\x10\x00\x00\x10\'\x00\x00\xda6&\x05\x90N&\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00zh{\x82wJ{\x82vG{\x83vH{\x83wJ{\x83wL{\x83wO{\x82xR{\x82xV{\x81xY{\x81x\\{\x80y^{\x80y_{\x80y^{\x80xZ{\x80xU{\x81wO{\x81wK{\x81vF{\x81vC{\x82vB{\x82vA{\x82v@{\x82v?{\x82v?{\x82v>{\x82v?{\x82u<{\x82u8{\x81t3{\x81t0{\x81t0{\x80t4{\x80u6{\x80u8{\x80u<{\x80vC{\x7fwK{\x80xT{\x80xZ{\x7fya{\x80zj{\x80{r{\x80|z{\x80|}{\x81{x{\x81~\x92{\x82\x83\xc4{\x82\x7f\xa0{\x83{u{\x84zg{\x84y^{\x85wO|\x85vE|\x86u;{\x86u:|\x85vF|\x84wP{\x83xU{\x82xY{\x81xY{\x80xW{\x7fxV{~xS{}xQ{|y^{{yc{zyb{zyd{yyf{yzh{yzi{yzi{yzh{yzj{zzj{zzi{{zf{{yd{|yc{|ye{|yf{}zf{}zh{~zi{~zk{\x7fzn{\x7fzp{\x80zp{\x80zn{\x80zj{\x80yd{\x81x\\{\x81xS{\x81wI{\x81ya{\x81~\x94{\x81zm{\x82wM{\x82vH{\x82vI{\x82wK{\x83wM{\x83wP{\x83xS{\x82xW{\x82xZ{\x82y]{\x81y_{\x81ya{\x82y_{\x82y]{\x82xW{\x82wQ{\x83wM{\x83wI{\x84vE{\x84vD{\x84vD{\x84vC{\x84vB{\x84vB{\x84vB{\x84vC{\x84v@{\x84u<{\x84u7{\x83t4{\x83&&&4+*(&021.#$#%%$%$#&$&6664*)()-/2;+..3..,...22,+/28=:11/22...0\x84cz\x88vus}w|\x7f\x7f\x8b\x80iwqqx\x86pu\x8b\x85ri^nxnkp|\x9e\xa9\x8dpju|\x84\x9b\x92n\x8f\x88\x88\x88\x88\x8a\x93\x80\x91\x99\x96\x93\x9c\x83\x96\x90\x7f\x8a\x8f\x8eabaIb^a__]^Z[YVYWVXYYVXXTTWVRTST:<=B>>=<=:;;=<=<<==?=?>>>A?@>>?A1:26811446<.384854645:2;89<A3587&($($(*&#$%$(3##$*/*)*$#%%)(#&%*\x88x~uu\x8a|\x88~|~\x85|x\x7fzr\x7f\x81y~\x88\x85\x8cusvtzz\x81uy\x85qw\x8f\x92\x80\x88\x83z\x94\x82\x84zx~\x80\x8a\x87\x89\x9a\x8et\x90\x8c\x8b\x91\x86\x83\x84~\x7fe\x86}\xad\x83wb\xa4h\x86\x88sv\x90tV\x99c\x91\x86dz\x98\x83x\x91\x94\x9c\x92\x82e\x81N\xc7E\x8az\x84\xb0:\xc8_\x99\xa3\xa8w}xVZ\x89I\x96uRb\x95F-xL\xd6\xb2E\x89\x8c\x82x\x83\x97\x85\x8a~\x8c\x89||\x86\x92\x89\x90\x8e\x8d\x82\x8e\x85\x8c\x8c\x84sx\x83\x8f\x89\x8a\x86t\x89\x97\x8a\x85sz\x87\x93\x80\x83t\x8a\x82\x82\x85\x90u\x86\x87\x97\x8d\x95\x90\x8e\x97\x87\x87\x96\x81z\x88\x8a\x81\xa8{\x99f\x8f\x8b\x82\x85\xa3\x86b\x84ou\x9c\x86\x9dR\x84x\xa6\x90\xae\x8c\x9c~r\x80\x88\x95\x8d|Z~\xda\x8e\x9fY\x80\x9a\x86\xd6\x84,\x84\xd0\xa5?:qt\xd6\x89m\x90_\x83H\x80\x9c\xa3~\xac\xac\xaa\xa6\x8d\x9a\xa8\xaa\x85v\x8c\x85\x83\x83\x87\x8d\xa4\x9a\x90\x8a\x9b\xa4\xa0\x9c\x80\x80\x84\x8e\x91\x81\x80\x7f\x9c\x9e\xa1\x9a\xa5\xaa\x98\xa0\xa5\x9a\xa1\x9d\x8f\x8e\x8b\x9d\x8a\x93\x81\x85\x89\x90\x95\x93\xa2\x9f\xa2\x96\x8f\x92\x98\x9b\x86\x89\x81\x85\x86\x80\x85\x88\x8e\x85\x89\x83\x92\x8c\x91\x8d\x89\x93\x92\x92\x81\x82\x85\x8bnvvvznpm\x8c\x85\x84~\x96\x98\x94\x92\x95\x9c\x9a\x9c\x88\x89\x90\x95\x86\x82\x88\x85|\x80\x7f\x7f\x88\x85\x82\x83\x90\x93\x8f\x8f%&:I$0"+ ;T4\x1f,)%67Y9=/66HIGAAHFH\x1c(=I.%&\x1f19V8&\x1f*.26U8+3-1A?=8=ACF*(*$\x1b\x1f$*\x10\x13\x14\x17\x0e\x0e\x0f\x10\x0c\r\x0e\x0e\n\n\n\x0b\t\t\n\n\t\x08\t\t\x08\t\x08\t\x08\x08\x08\t\x07\x07\x08\x08\x07\x07\x07\x07\x06\x06\x06\x06\t\t\x08\x08\x0b\x0b\n\n\n\x0b\x0b\x0c\x93\xbf\xacc\x8d\xa6asn\xb3\xc3\x96xs\x9a_\x81\x8cj\xb0yv^\x80\x94yyev\x8a\x90xL\x9a\x91\x80\x90oP|\xb5\x89\x80L\x99R\xa9qac\x86\xb5hayZ\x8d\x90\x83gVx\x8c\x91\xa3\x93}h\xa8\xba\xa1\xa4\xb2\xbc\xab\xbf\xb7\xaa\xb1\xb9\xb6\x9c\xc0\xa9\xa8\xa5\xb5\x9a\xc2\xc8\xb4\xbf\xcf\xbd\xd2\xc1_py\xa1l\x80\\n\x80\x92q\x92_f\x87\x9d1@K]hTBGcQl]YF\\K\x9di`r\xe0\x9acr>R\xaa\x9dk\x8eQH\x97mz\x8f\xaec\x88\xa3\x8a\xb0\xb1\xc4\x96\x98\x8f\x91\xc5\xdc\xce\x97\xaeV\x95\xafFT\xa1\x98R\x8e\x95>\x83z\x94v\xaf\x91\x80]Qz\xa5\x8apf\x8cd\xb0\x94\xa6\x99\xc5\xbb\xc6\xb1\xc5\xd4\xc4\xd2\xcd\xdc\xcf\xd4\xde\xdd\xd0\xda\xe5\xdb\xe4\xda\xb7\xd7\xce\xcc\xd7\xc8\xb6\xca}\x89\xb2\xa88<N_\x1a!",2A\x1a g`6G\xc6\xb7\x9d\x8e\xcc\xd7\xc8\xd5\xd1\xd1\xcc\xd8\xd6\xd8\xd8\xdc\xd8\xd5\xdb\xd9`^]wn_lh\x00\x00\x00\x00\x00\x00\x00\x00'
sRec2 = 'c\x00\x00\x00\xa1=\x01\x00QU&\x05A\x00\x00\x00\x10\x00\x00\x00\xdd\x00\x00\x00A\x00\x00\x00\x00\x00\x00\x00N\x0cJ\x08\xfc\x00\x00\x00\xc7\x00\x00\x00\xa6\x00\x00\x00\xff\xff\x8a\x00DA\x00\x00[\xe9\xff\xff\x11<\x00\x00\xa0\x93\xa2\r\x18i\t\x007\x1a\x11\x00\xf4#\x01\x00\x08\xc8\x01\x00\xdc"\x0b\x007\x00\x00\x00\'\x00\x00\x00\xf2\xff\xff\xff\xdc\xff\xff\xff\xa0\xcb4\x00\xba\xe7\xff\xffD\x08\x00\x00x\x1d\x00\x00\xef\x1b\x00\x00\x9d\xf6\xff\xff\xa5\x19\x00\x00\x82\x0c\x00\x00\x02%\x00\x00\xec\xff\xff\xff \x1a"\xf8p@\xaf\x02\x10\x17Q\x0f\x18N\x00\x00\xf4\x0e\x00\x00\x11<\x00\x00\x9d\xe5\xff\xff\x93\xe5\xff\xff\x8b\xf4\xff\xff\xa0\xc2\xff\xff\x10\'\x00\x00E\n\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00t3{\x82u6{\x82u9{\x82u:{\x82v>{\x81vD{\x81wL{\x81xT{\x80x[{\x80yb{\x80zj{\x80{r{\x80|{{\x81|~{\x81|z{\x82}\x8c{\x83\x84\xcb{\x83\x80\xa6{\x84{y{\x84zi{\x84y`{\x85xR{\x85vG|\x86u=|\x86u:|\x85vF{\x84wP{\x83xV{\x82xZ{\x81xZ{\x80xY{\x7fxW{}xU{|xR{{y]{zyd{zyd{yyd{xzf{xzi{xzj{xzj{xzj{xzk{yzl{yzk{yzh{yyf{yyd{zyf{zzg{{zg{{zh{|zi{|zk{|zn{}zp{}zp{~zn{~zk{\x7fye{\x7fy]{\x7fxU{\x80wK{\x80xY{\x80\x7f\x9b{\x81{s{\x81wP{\x82wI{\x82wI{\x82wK{\x83wN{\x84wP{\x84xT{\x84xW{\x83xZ{\x82y]{\x82y`{\x82ya{\x82y`{\x82y^{\x82xY{\x82xR{\x83wN{\x83wJ{\x84vF{\x84vD{\x84vE{\x84vD{\x84vC{\x84vC{\x84vC{\x84vE{\x84vB{\x84v>{\x84u:{\x84u6{\x83u5{\x83u7{\x82u:{\x82u;{\x81u>{\x81vD{\x80wL{\x80xT{\x80x[{\x80yb{\x80zj{\x80{r{\x80|{{\x81|\x7f{\x81||{\x82}\x87{\x82\x83\xc8{\x83\x80\xac{\x84|~{\x84zk{\x84yb{\x85xU|\x85wJ|\x86v@|\x86u;|\x85vE{\x84wQ{\x83xW{\x82xZ{\x81x[{\x80xZ{\x7f\'&*(()&\')%%+222+233,-,,+./0,***/25501230)+*/+./:.+,0322.1../454N]ur~Ocn]hffZe`edDFX\\acQYc[edFQXZ\x94\x8d\x91\x89\x9d\x9e\x93\xa1u|\x85\x88\x9a\x8dis\x90\x92~ynf\x8c\x9ar\x83xm\x7fuz\x82SROQSQPNMLJLKKMLMLLJIIHHGDGHFFDF@@<CD@BC@@CDF@FHCFCEmmm[EHKNTRRW/498796286837;62;8897784:62D88==&+#($$&,)$(&"$%%&)\'**"$%&%#\'$%)+\x82z\x82\x80wzxv\x86\x81\x83|v{|\x82jlyv\x7f\x82|w\x83sv\x81}\x82}}\x80\x8e|\x80\x8b\x84\x83\x9a\x8e|zz\x90\x9a\x8f\x86x\x82\x84{\x83z\x89x\x80\x8dt\x99\x7f\x83\x82[\xa0j}\xb4vdy\x92x\x98|\x8b\x81\x81\xa2\x82\xa4w{d\x94\x8e\xa2t\x83\x81\x83fvy{xvU\xb86\xbaQp\x88u\x88\xa3h\x90tI9\x99{Gj\x8a\\G@\xa4sX\x8b\x82\xc7zy\x8a\x86\x88\x86\x95\x8d\x8d\x84\x8c\x81\x84\x86\x8e\x95\x87\x8ct~}\x87\x85\x86\x90\x8b\x83\x81\x87\x8d\x81\x84\x81\x88\x81\x82\x84|\x8cw\x86\x86\x96{\x92\x80\x84\x82\x7f\x8c\x82\x81|\x82\x88\x8b\x8e}\x90z\x87\x97{\x82\x8aww\xb7\x82\x87k\x80\x8c\x86x\x82m\x8c\x88\x8a\x7f\x8alRVra|u\x80\x9a\xac\x8a\x8b\x86\x87\x9e\x90A\xac\x85\x88Y\x81\xa9\xaaCp}IP\xcf\x98s\xa23\xa6\x8aM\xc4\xa9\x96\xba\xc3\xa7\xac\x80\x8f@.\xa1\x9e\x9f\x97\x9d\x94\x94\x9a\x9a\x94\x9d\xa9\x9a\x8e\x8e\x95\x91\x93\xa0\x9a\x92\x8d\x8f\x9b\x9b\x8c\x91\x9a\x8d\x9c\x90\x94ksc\x89lcfn\x90\x88\x86\x83{{\x80~\xaa\x9d\x96\x82\xa4\x9d\xae\xa4\x92\x99\x9d\x9e\x9a\x98\x91\x8a\x96\x92\x90\x93\x98\x98\x99\x98\x90\x94\x96\x96\x89\x84\x86\x8d\x96\x93\x90\x8c\x90\x94\x94\x96\x95\x96\x95\x94\x8c\x8e\x91\x93\x91\x91\x90\x8d\x93\x93\x8f\x91\x95\x98\x98\x92\x92\x90\x95\x98\x96\x94\x92\x90\x9a\x9c\x9c\x96\x8e\x8f\x90\x94\x83}\x7f\x8b&!2G\x13\x1a\x16\x1b+:R(\x1c \'047[D6).3AC9:BCAB".<D!\x11\x1c$\x1b8T2*$-"?8W?<A>@DC=8IHCB/.*\x15\')02\x19\x1c\x1f"\x12\x13\x14\x16\r\x0e\x0f\x10\x0f\x0f\x0e\x0e\r\x0e\x0e\x0f\x10\x0f\x0e\r\x0c\x0e\x10\x10\x0f\r\x0b\x0b\x14\x13\x12\x11\x12\x14\x15\x15\x0e\x0e\x0f\x10\x11\x11\x11\x0f\r\x0f\x10\x11\r\x0c\x0c\rl\xa3ry\x885tC\xce_ph\xa9Z\x9e\xaev\x84\x80\xa9RDdT\x86\x88\x84Q\x97h\x94\x82\x7fm7}P}\xb0\xb1\x8a\x8c\x8e8\x9a\xaa\xc5\xa4\x80b\x87\x99|p\x8c\x86c|yflwc\x8f\x84\x84rJ\x8e\x84zxd`g\x84Tbpm\x8fnQL^x\x98\xa4\x92|sZ\xcc\xc7\xb8\xa1\xe0\xe5\xdd\xd8\x9d\xc4\xda\xe1[`jy\xa9\x93\x86i|\x88\xb0\xb2SUZsl^XW\xa7\xa2\x93\x84PwJ\x80TdO\x9fwj\xc4\x8aEB*Tm=FUBjp\x8f\x88\xb3@Rt\x80\x9c\x94\x8eT\x9f\x93o\xa7\xcf\xae\xa5g\xbd\x89IA\x89\x85zT^{\xbc\xb9\x8d\xb5p\xaf\xb3\xa0sf~>o\x8c\xa2\xbd/7EZzY>.\xa7\xb3\xac\x94YTf\x86\x98\xa8\x9f~a^a\x7fr`TV\x96\x82qp\xa0\xaf\x96\x96[w\x89\x93QIAE\x93\x9c\x8aa\xab\xaa\xad\xa9\xd9\xcd\xc2\xb8\xd1\xc1\xcc\xd4\xda\xcf\xd5\xdc\xd4\xd9\xce\xd4fhlllejb\x00\x00\x00\x00\x00\x00\x00\x00'

print "1st Record Time:", depwi.gettime(sRec1)
print "2nd Record Time:", depwi.gettime(sRec2)

print "Time Cmp:", depwi.timecmp(sRec1, sRec2)

# SFR Testing
tSfrA = depwi.getsfr(sRec1, "A")
tSfrB = depwi.getsfr(sRec1, "B")

print "Rec1: SFR A, Antenna ", tSfrA[0]

for t in tSfrA[1]:
	print "   Time %d %d  Freq %.3e  Amp %.3e %.3e %.3e %.3e"%t


print "Rec1: SFR B, Antenna ", tSfrB[0]

for t in tSfrB[1]:
	print "   Time %d %d  Freq %.3e  Amp %.3e %.3e %.3e %.3e"%t


tSfrP = depwi.getsfr_phase(sRec1)
print "Rec1: SFR %s - %s Phase"%(tSfrP[0], tSfrP[1])
for t in tSfrP[2]:
	print "  Time %d %8d  Freq %.3e  Phase %3.0f %3.0f %3.0f %3.0f  Corr %.2f %.2f %.2f %.2f"%t


tSfrP = depwi.getsfr_phase(sRec2)
print "Rec2: SFR %s - %s Phase"%(tSfrP[0], tSfrP[1])
for t in tSfrP[2]:
	print "  Time %d %8d  Freq %.3e  Phase %3.0f %3.0f %3.0f %3.0f  Corr %.2f %.2f %.2f %.2f"%t


# LFC Testing

tLfcA = depwi.getlfc(sRec1, "A")
tLfcB = depwi.getlfc(sRec1, "B")

print "Rec1: LFC A, Antenna ", tLfcA[0]

for t in tLfcA[1]:
	print "   Time %d %d  Freq %.3e  Amp %.3e %.3e %.3e %.3e %.3e %.3e %.3e %.3e"%t

print "Rec1: LFC B, Antenna ", tLfcB[0]

for t in tLfcB[1]:
	print "   Time %d %d  Freq %.3e  Amp %.3e %.3e %.3e %.3e %.3e %.3e %.3e %.3e"%t

tLfcP = depwi.getlfc_phase(sRec1)
print "Rec1: LFC %s - %s Phase"%(tLfcP[0], tLfcP[1])

for t in tLfcP[2]:
	print "  Time %d %8d  Freq %.3e  Phase %3.0f %3.0f %3.0f %3.0f %3.0f %3.0f %3.0f %3.0f  Corr %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f"%t

tLfcP = depwi.getlfc_phase(sRec2)
print "Rec2: LFC %s - %s Phase"%(tLfcP[0], tLfcP[1])
for t in tLfcP[2]:
	print "  Time %d %8d  Freq %.3e  Phase %3.0f %3.0f %3.0f %3.0f %3.0f %3.0f %3.0f %3.0f  Corr %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f"%t


# DC Testing

tDc = depwi.getdc(sRec1)  # Always returs nothing for the first call
tDc = depwi.getdc(sRec2)  # since record diferences are used internally

print "Rec2: DC Componets"
for t in tDc[0]:
	print "   Time %d %8d  Ant %s  Spin Perp %.3e (V/m)  Spin Par %.3e (V/m)  Chi %.3e "%t

for t in tDc[1]:
	print "   Time %d %8d  Ant %s  Axis Par %.3e (V/m)  Std Dev %.3e "%t


# Orbit Paramteters

print "Rec1: Orbit Params"
tOrb = depwi.getorb(sRec1)
print "   Time %d %8d  R %.3e (Re)  L %.3e (Re)  LT %.3e (Hrs)  Mlat %.3e (deg)"%(
      tOrb[0], tOrb[1], tOrb[36], tOrb[9], tOrb[8], tOrb[37])

print "Rec1: Orbit Params"
tOrb = depwi.getorb(sRec2)
print "   Time %d %8d  R %.3e (Re)  L %.3e (Re)  LT %.3e (Hrs)  Mlat %.3e (deg)"%(
      tOrb[0], tOrb[1], tOrb[36], tOrb[9], tOrb[8], tOrb[37])


# Status Words
sHdr = "  Day   Millisec  LLC SSM LBA LAA SBA SAA SGa CaI CaE SAS LAS LLS LHS SSw S40 LC0 St0 S42 LC2 St2 S44 LC4 St4 S46 LC6 St6 XMT" 
sFmt = "  %d %8d  %3s sk%d %3s %3s %3s %3s %3s %3s %3s %3s %3s %3s %3s %3s  x%d %3s %3s  x%d %3s %3s  x%d %3s %3s  x%d %3s %3s %3s" 

print "Rec1: Status"
t = depwi.getstatus(sRec1)
print sHdr
print sFmt%t

print "Rec2: Status"
t = depwi.getstatus(sRec2)
print sHdr
print sFmt%t
