# Flags ######################################################################

FC= gfortran
FFLAGS= -Wall -std=legacy -fPIC

#CC= gcc 
#CFLAGS= -Wall -std=c99 -O -I$(INST_INC)

#LIBS= -lgfortran -lm 

export BUILD_DIR

# Pattern Rules ##############################################################

$(BUILD_DIR)/%.o:src/%.c  | $(BUILD_DIR)
	$(CC) $(CFLAGS) -c $< -o $@

$(BUILD_DIR)/%.o:src/%.f | $(BUILD_DIR)
	$(FC) $(FFLAGS) -c $< -o $@

$(INST_NAT_BIN)/%:$(BUILD_DIR)/%
	install -D -m 775 $< $@
	
$(INST_NAT_LIB)/%:$(BUILD_DIR)/%
	install -D -m 664 $< $@
	
$(INST_INC)/%.h:src/%.h
	install -D -m 664 $< $@

$(INST_HOST_BIN)/%:$(BUILD_DIR)/%
	install -D -m 775 $< $@

$(INST_HOST_LIB)/%:$(BUILD_DIR)/%
	install -D -m 664 $< $@
	
# Explicit Rules #############################################################

BD=$(BUILD_DIR)
IHB=$(INST_HOST_BIN)
IHL=$(INST_HOST_LIB)
IEL=$(INST_EXT_LIB)

# Keep *.o files around
#.PRECIOUS:$(BUILD_DIR)/%.o

build: $(BD)/de_pwi $(BD)/libdepwi.a $(BD)/depwi.so

install:$(INST_NAT_BIN)/de_pwi $(INST_NAT_LIB)/libdepwi.a $(INST_INC)/depwi.h\
  $(INST_EXT_LIB)/depwi.so

$(BD):
	@if [ ! -e "$(BD)" ]; then mkdir $(BD); fi

$(BD)/de_pwi:$(BD)/pwi.o $(BD)/libdepwi.a
	$(FC) $(FFLAGS) -o $@ $^ $(LIBS4)
	
$(BD)/libdepwi.a: $(BD)/libr.o $(BD)/util.o
	ar -r $@ $^

$(BD)/depwi.so:src/pywrap.c $(BD)/libdepwi.a
	python$(PYVER) setup.py build_ext --build-lib=$(BD) \
 --build-temp=$(BD)
  
$(IEL)/depwi.so:$(BD)/depwi.so
	install -D -m 775 $< $@
 
#$(IHL)/depwi.pyc:$(IHL)/depwi.py
#	python -c "import py_compile; py_compile.compile('$<', '$@' )"
 
clean:
	rm -f $(BD)/*.o

distclean:
	rm -r $(BD)
