pro magAng, Bx, By, Bz, Bphi, Btheta
; compute Bphi and Btheta from B vector using routine adapted from magang.for
; written by Swami Reddy, Oct 1981 for the Sigma-9
; Robert.M.Candey@nssdca.gsfc.nasa.gov, 1995 March 27

; alternative but not the same (computes the wrong quadrant?):
; Bphi = acos(Bx/sqrt(Bx^2+By^2)) *180./!pi
; Btheta = acos(Bz/sqrt(Bx^2+By^2+Bz^2)) *180./!pi

Bphi = atan(By, Bx) * 180./!pi
w = where(Bphi lt 0., wc)
if (wc gt 0) then Bphi(w) = Bphi(w) + 360.
Bmag = sqrt(Bx^2 + By^2 + Bz^2)
Btheta = Bmag * 0. ; initialize array
w = where(Bmag gt 0., wc) ; prevent divide by zero errors
if (wc gt 0) then $
  Btheta(w) = atan(sqrt(Bx(w)^2 + By(w)^2)/Bmag(w), Bz(w)/Bmag(w)) * 180./!pi
w = where(Btheta lt 0., wc)
if (wc gt 0) then Btheta(w) = Btheta(w) + 360. ; is this right? want 0-180 deg
return
end ; magAng
