FUNCTION TRAP_energy, X, Y
;  DX = X - SHIFT(X,1) & DX = DX(1:*)
;  W = INDGEN(N_ELEMENTS(DX))
;  A = DX*0.
;  A(W) = .5*DX(W)*(Y(W) + Y(W+1))
;  T = TOTAL(A)
;  RETURN, T
  nX = n_elements(x)
  w = indgen(nX)+1
  alogX = alog(x)
  alogXs = spline(findgen(nX),alogX,findgen(nX+2)-1.) ; add outside points
  dx = exp((alogXs(w)+alogXs(w+1))/2.) - exp((alogXs(w-1)+alogXs(w))/2.)
  return, total(dx * y)
END ; trap_energy
FUNCTION TRAP_angle, X, Y
  nX = n_elements(x)
  w = indgen(nX)+1
  Xs = spline(findgen(nX),X,findgen(nX+2)-1.);add outside points
;  dx = (Xs(w)+Xs(w+1))/2. - (Xs(w-1)+Xs(w))/2.
  dx = (Xs(w+1) - Xs(w-1))/2.
  return, total(dx * y)
END ; trap_angle
function currentsr, inputHLAPI, inputEA, inputEnergy, inputFlux, $
	energyRange=energyRange, PArange=PArange, ionType=ionType
; calculate currents for HAPI or LAPI data for inputEA and inputHLAPI
; Expects data for one sweep only
; current integration for single range of pitch angle and energy
;	HAPI not available (if fixed, please send to me at address below)
; Inputs are:
;    inputEA = EA_rec structure with data for each sweep
;    inputHLAPI = HLAPI_rec structure with top level data for each pass
; Optional inputs are:
;    energyRange = [low energy, high energy] to integrate over, in eV
;	defaults to full range available [4, 32000]
;    PArange = [low angle, high angle] of Pitch Angle, in degrees
;	defaults to full range available [0, 180]
;    ionType = 0 for electrons, 1 for protons, n>1 for larger masses
; 1991 September 21  Bobby Candey, Atlantic Research
; integrate over energies before pitch angles
; add running multiple currents 1991 October 11 BC
; add use of flux as input instead of calc_flux  12 October 1991 BC
; added spline over all angles before truncation  14 Oct 1991 BC
; changed to return array of zeros when not in energy/PA range  9 Dec 1991 BC
; changing integration to use center energy  Bobby Candey, Hughes STX 1992 Ap 15
; changed for future use in HAPI; Bobby Candey; 1995 Jan 10
;		Robert.M.Candey@gsfc.nasa.gov

;### make sure flux is set to minimum for counts < 1

if keyword_set(ionType) then ionType1 = ionType else ionType1 = 0 ; electrons
if keyword_set(PArange) then PArange1 = PArange else PArange1 = [0.0d0, 180.0d0]
if keyword_set(energyRange) then energyRange1 = energyRange else $
	energyRange1 = [4.0, 32000.0]

satID = inputHLAPI.satID
;###if (satID ne 'L') then return, 0.0	; skip for HAPI
if (satID ne 'L') then print, 'HAPI current calculation has not been verified'

; define constants
pi = 4.0d0 *atan(1.0d0)
degrad = pi / 180.0d0
if (ionType1 le 0) then mass = 9.11d-31 else mass = 1.67d-27 * ionType1
	; mass of electron and proton, in kg
eV2J   = 1.6021892d-19	; convert energy in eV to Joules
charge = 1.6021892d-19	; charge of electron, Coulombs

; transfer inputEA and inputHLAPI data into free variables
yrday = inputHLAPI.yrday
time = inputEA.time
if (n_params(0) gt 3) then begin ; use energy and flux from outside
  energies = inputEnergy
  if (ionType1 le 0) then flux_elec = inputFlux else flux_ions = inputFlux
endif else begin ; compute fluxes
  fluxOption = 2	; number flux
;  calc_flux_c, inputHLAPI, inputEA,fluxOption, fluxType, energies, flux_elec, $
;	flux_ions ; , fluxZero_elec, fluxZero_ions
  calc_flux, inputHLAPI, inputEA,fluxOption, fluxType, energies, flux_elec, $
	flux_ions ; , fluxOne_elec, fluxOne_ions
endelse

outputCurrent = dblarr(n_elements(inputEA))
for nTime = 0L, n_elements(inputEA)-1 do begin ; over all time

if (ionType1 le 0) then begin ; electrons
  flux = flux_elec(*,*,nTime)
  angles = inputEA(nTime).PA_elec
  sensors = inputEA(nTime).sensors_elec
endif else begin ; ions
  flux = flux_ions(*,*,nTime)
  angles = inputEA(nTime).PA_ions
  sensors = inputEA(nTime).sensors_ions ; (*,0)
endelse
if keyword_set(energyRange) then begin
  wEV = where((energies ge energyRange1(0)) and (energies le energyRange1(1)),wc)
  if (wc le 0) then begin
	print, 'No energies in requested range', energyRange
	return,outputCurrent
  endif
  energies0 = energies(wEV)
  flux0 = flux(*,wEV)
endif else begin
  energies0 = energies
  flux0 = flux
endelse

if (satID eq 'H') then begin ; HAPI
  angles1 = angles
  flux1 = flux0
endif else begin ; LAPI
;###skip field-aligned sensors?
;### correct for 15deg detector (2) * 1.25? no, now treated by calc_flux
;if (wc gt 0) then begin
  wGood = where((sensors gt 3) and (sensors lt 26), wc)
  flux1 = flux0(wGood,*)
;  sensors1 = sensors(wGood)
  angles1 = angles(wGood)
;endif ; found bad sensors
endelse ; LAPI

;### extend trap to integrate 0 flux on ends of ranges and/or interpolate flux 
;###    at endpoints

;### sort pitch angles?
  sAngles = sort(angles1)
  angles2 = angles1(sAngles)
  flux2 = flux1(sAngles,*)
  wAngles = where((angles2 ge PArange1(0)) and (angles2 le PArange1(1)), wc)
  if (wc le 0) then begin
	print, 'No pitch angles in requested range', PArange
	return, outputCurrent
  endif
    ; find outer boundary angles to integrate over

flux3 = flux2 * 1.d4 ; conversion to C/(m^2 s str J)
angleCurrent = angles2 * 0.0d0 ; set array up
for j = 0L, n_elements(angles2)-1 do begin
;  angleCurrent(j) = trap(energies0*eV2J, flux3(j,*))
  angleCurrent(j) = trap_energy(energies0*eV2J, flux3(j,*))
endfor ; j index into angles

angleCurrentEnds = spline(angles2*degrad, angleCurrent, PArange1*degrad)
angles3 = [PArange1(0), angles2(wAngles), PArange1(1)]
angleCurr = [angleCurrentEnds(0), angleCurrent(wAngles), angleCurrentEnds(1)]

mu = cos(angles3*degrad)
outputCurrent(nTime) = -2.0d0 * pi * trap(mu, -angleCurr * mu)
;outputCurrent(nTime) = -2.0d0 * pi * trap_angle(mu, -angleCurr * mu)

endfor ; nTime
return, outputCurrent
end ; currents
