pro contour_even, x, y, log=log
; CREATE EVEN (exact) SCALE PLOT with equal data units plotting as equal 
;	distances on the X and Y axes
; Bobby Candey, Atlantic Research Corp.   1991 April 11
; alters !p.position and !p.multi and !x/y.range
; converted to set up for contouring ; Bobby Candey, Hughes STX, 13 Nov 1992

!p.position = 0
!p.multi = 0 ; reset to 1 plot per page

!x.range = [min(x), max(x)]
!y.range = [min(y), max(y)]
if keyword_set(log) then plot_oo,!x.range,!y.range else $
	plot,!x.range,!y.range ; dummy plot to set !x/y.crange and !x/y.window
wx = !x.window & wy = !y.window ; window size in normalized coordinates
;if keyword_set(log) then begin
;  xr = alog10(!x.crange(1)) - alog10(!x.crange(0)) ; data range in data coordinates
;  yr = alog10(!y.crange(1)) - alog10(!y.crange(0))
;endif else begin
  xr = !x.crange(1) - !x.crange(0) ; data range in data coordinates
  yr = !y.crange(1) - !y.crange(0)
;endelse
xdevice = wx * float(!d.x_size) ; current window in pixels
ydevice = wy * float(!d.y_size)
xrdevice = xdevice(1) - xdevice(0) ; current window width in pixels
yrdevice = ydevice(1) - ydevice(0)
xratio = xr / xrdevice ; data units per pixel
yratio = yr / yrdevice
ratio = max([xratio, yratio])
newxmaxnorm = (xr / ratio + xdevice(0)) / float(!d.x_size)
newymaxnorm = (yr / ratio + ydevice(0)) / float(!d.y_size)
!p.position = [wx(0), wy(0), newxmaxnorm, newymaxnorm]

;if keyword_set(log) then plot_oo,x,y else plot,x,y
return
END                                     
