#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
   int sockfd;
   int len;
   struct sockaddr_in address;
   int result;

   // read local date
   FILE *ifp = popen("date \"+%Y-%m-%d %H:%M:%S\"", "r");
   if (ifp==NULL) {
      fprintf(stderr, "error calling popen() to get local date/time\n");
      perror("");
      close(sockfd);
      exit(1);
   }

   char datebuf[20];
   fread(datebuf, 19, 1, ifp);
   datebuf[19] = '\0'; 
   pclose(ifp);
 
   printf("Local date/time is %s\n", datebuf); fflush(stdout);


   // create a socket for the client
   sockfd = socket(AF_INET, SOCK_STREAM, 0);
   
   // name the socket
   address.sin_family = AF_INET;
   address.sin_addr.s_addr = inet_addr("130.183.73.21");
   address.sin_port = 9734;
   len = sizeof(address);
   
   // connect the socket to the server's socket
   result = connect(sockfd, (struct sockaddr *)&address, len);
  
   if (result == -1) {
      perror("oops: dateclient");
      exit(1);
   }
   printf("connected to server.\n");

   printf("Sending local date to the server.\n");
   write(sockfd, datebuf, 20);

   // read the server's date/time
   read(sockfd, datebuf, 20);

   printf("server's date/time is : %s\n", datebuf); fflush(stdout);

   close(sockfd);

   printf("Updating local time\n");
   char commandbuf[256];
   sprintf(commandbuf, "date -s \"%s\" \"+%%Y%%m%%d%%H%%M%%S\" >/dev/null 2>&1", datebuf);
//   printf("command to be executed: %s\n", commandbuf);
   system(commandbuf);
   printf("Local time is now: "); fflush(stdout);
   system("date"); 

   exit(0);

}
