FUNCTION sensor_fill, data_word, sub_com
; CLUSTER II IDL Function
;
; sensor_fill.pro
;
; created by: Mark Chutter, UNH
; Aug. 25, 1999
;
; Modified:
; Sep.  1, 1999 I Made this much more useful by convert the hex
;               values to floats where needed.
; MWC Oct. 19, 1999 MWC added common block hk_structs
;
; Calling Interface:
; data_word  byte  (i)  raw analog sensor data
; sub_com    byte  (i)  subcom value
;
; Return Value:
; A filled sc_pick_ana_sensor_struct
;
; Description:
; This routine returns the current analog sensor data.
COMMON hk_structs, sc_pick_ana_sensor_struct, sc_pick_dig_sensor_struct, sc_pick_sensor_struct, sc_pick_gdu_01_struct, sc_pick_gdu_23_struct, sc_pick_gdu_45_struct, sc_pick_gdu_67_struct, sc_pick_gdu_struct, sc_pick_I_V_struct, sc_pick_hk_struct

sensor = sc_pick_ana_sensor_struct

CASE sub_com OF

    0:sensor.rf25 = float(data_word) * (-0.0025) + 2.8187
    1:sensor.hvcr = float(data_word) * (-0.250) + 56.875
    2:sensor.hver = float(data_word) * (-0.250) + 5.6875
    3:sensor.hvrf = float(data_word) * (-0.0125) + 2.8438
    4:sensor.prgn = float(data_word) * (-0.0250) + 5.6875
    5:sensor.n_5v = float(data_word) * (-0.010) - 3.725
    6:sensor.p_5v = float(data_word) * (-0.010) + 6.275
    7:sensor.stmp = float(data_word) * (-0.50) + 78.75

ENDCASE 

return, sensor
END
