FUNCTION pickn_sc, mode_id, status, $
                   get_hk_data = get_hk_data
; CLUSTER II IDL Procedure
;
; Abstract: Pick the next available science packet of the designated type
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; Nov. 22, 1998
;
; modified:
; Mar. 23, 1999 Mark Chutter added PICK_LIB environment variable
; Mar. 31, 1999 Mark Chutter added mode_id
; May  25, 1999 Mark Chutter added the ugly code to copy bm1 data into
;                            the proper old-style structure
; June  9, 1999 Mark Chutter added the ugly code for rdm and cdm
; July  7, 1999 Mark Chutter replaced CALL_EXTERNAL
; July 21, 1999 Mark Chutter added ctm; changed read_packet 
; Apr. 21, 2000 Mark Chutter added msf file type
; Aug.  9, 2001 MWC added get_hk_data keyword
;
; Calling Interface:
; mode_id       long    (i)     Science Mode 
; status        long    (o)     Status of PICK-Operation (see PICK-Lib)
;
; Return Value:
; Structure of type PICK_SC_RECORD
;
; Description:
; This function starts the PICKN_SC Module from the UNIX Pick Library
; and returns the received data in a structure.
;
; Example:
; 
; PSTATUS = LONG(0)
; SMS     = ' '
; sc_pick_id = long(11)
;
; ...
; SR = PICKN_SC(sc_pick_id,PSTATUS)
; if not PSTATUS then begin
;   PICK_get_msg,PSTATUS,sms
;   print,sms
; endif
; help, /struct, sr.hdr
; ...
;
COMMON pick, file_type, pick_lun
COMMON pick_buffer, pick_buffer, pick_buf_ptr

packet_num = 0L
packet_time = lonarr(2)
packet_time[0] = 0L
packet_time[1] = 0L

IF keyword_set(get_hk_data) AND file_type NE 'msf' THEN BEGIN
    print, 'get_hk_data keyword can be used with MSF file type only'
    pick_error = {status: REQUEST_HK_FROM_NON_HK_DATA}
    return, pick_error
ENDIF

CASE file_type OF

    'cdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'rdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'msf':pick_record = read_packet(mode_id, packet_num, packet_time, $
                                    get_hk_data = get_hk_data)

    'ctm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'etm':pick_record = read_etm(mode_id, packet_num,  packet_time)

    'tlm':pick_record = read_tlm(mode_id, packet_num,  packet_time)

ENDCASE

status = pick_record.status

return, pick_record

END
