FUNCTION pickn_pk, mode_id, status
; CLUSTER II IDL Procedure
;
; Abstract: Pick the next available packet of the designated type
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; Apr. 2, 1999
;
; Modified:
; Jul.  8, 1999 Mark Chutter replaced CALL_EXTERNAL
; July 21, 1999 Mark Chutter added ctm; changed read_packet 
; Apr. 21, 2000 Mark Chutter added msf file type
; Oct. 12, 2000 MWC removed extra endelse
;
; Calling Interface:
; mode_id       long    (i)     Packet type 
; status        long    (o)     Status of PICK-Operation (see PICK-Lib)
;
; Return Value:
; Structure of type PICK_SC_RECORD
;
; Description:
; This function starts the PICKN_PK Module from the UNIX Pick Library
; and returns the received data in a structure.
;
; Example:
; 
; PSTATUS = 0L
; SMS     = ' '
; pick_id = 11L
;
; ...
; SR = PICKN_PK(pick_id,PSTATUS)
; if not PSTATUS then begin
;   PICK_get_msg,PSTATUS,sms
;   print,sms
; endif
; help, /struct, sr.hdr
; ...
;

COMMON pick, file_type, pick_lun

packet_num = 0L
packet_time = lonarr(2)
packet_time[0] = 0L
packet_time[1] =  0L

IF file_type EQ '' THEN print, 'File type not set'

CASE file_type OF

    'cdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'rdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'msf':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'ctm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'etm':pick_record = read_etm(mode_id, packet_num,  packet_time)

    'tlm':pick_record = read_tlm(mode_id, packet_num,  packet_time)

ENDCASE

return, pick_record

END
