FUNCTION picka_sc, mode_id, status, $
                   get_hk_data = get_hk_data
; CLUSTER II IDL Procedure
;
; Abstract: Pick the next available science packet of any type
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; Nov. 22, 1998
;
; modified: 
; Mar. 23, 1999 Mark Chutter added PICK_LIB environment variable
; Mar. 31, 1999 Mark Chutter added moded_id
; May  25, 1999 Mark Chutter added the ugly code to copy bm1 data into
;                            the proper old-style structure
; Jun. 09, 1999 Mark Chutter added the ugly code for rdm and cdm
; Jul.  8, 1999 Mark Chutter replaced CALL_EXTERNAL
; July 21, 1999 Mark Chutter added ctm; changed read_packet 
; Aug.  6, 1999 Mark Chutter status now gets set
; Apr. 19, 2000 Mark Chutter added msf file type
; Aug.  9, 2001 MWC added get_hk_data keyword
;         
; Calling Interface:
; mode_id       long    (o)     Science Mode 
; status        long    (o)     Status of PICK-Operation (see PICK-Lib)
;
; Return Value:
; Structure of type PICK_SC_RECORD
;
; Description:
; This function starts the PICKA_SC Module from the UNIX Pick Library
; and returns the received data in a structure.
; mode_id will be assigned with the mode id of the current SC packet.
; 
; Example:
; 
; PSTATUS = LONG(0)
; SMS     = ' '
; sc_pick_id = long(0)
;
; ...
; SR = PICKA_SC(sc_pick_id,PSTATUS)
; if not PSTATUS then begin
;   status=PICK_get_msg(PSTATUS,sms)
;   print,sms
; endif
; print, 'Science Packet Type: ',sc_pick_id
COMMON pick, file_type, pick_lun
@pick_const
packet_num = 0L
packet_time = lonarr(2)
packet_time[0] = 0L
packet_time[1] =  0L
status =  0

IF keyword_set(get_hk_data) AND file_type NE 'msf' THEN BEGIN
    print, 'get_hk_data keyword can be used with MSF file type only'
    pick_error = {status: REQUEST_HK_FROM_NON_HK_DATA}
    return, pick_error
ENDIF

mode_id = 2 ;mode_id of 2 means any science packet in read_rdm and read_cdm

CASE file_type OF

    'cdm':pick_record = read_packet(mode_id, packet_num, packet_time)

    'rdm':pick_record = read_packet(mode_id, packet_num, packet_time)

    'msf':pick_record = read_packet(mode_id, packet_num, packet_time, $
                                    get_hk_data = get_hk_data)

    'ctm':pick_record = read_packet(mode_id, packet_num, packet_time)

    'etm':pick_record = read_etm(mode_id, packet_num, packet_time)

    'tlm':pick_record = read_tlm(mode_id, packet_num, packet_time)

ENDCASE

status = pick_record.status

IF pick_record.status GT 0 THEN BEGIN
mode_id = pick_record.status
ENDIF

return, pick_record

END
