FUNCTION picka_pk, mode_id, status
; CLUSTER II IDL Procedure
;
; Abstract: Pick the next available packet of any type
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; Apr. 2, 1999
;
; Modified:
; July  8, 1999 Mark Chutter replaced CALL_EXTERNAL
; July 21, 1999 Mark Chutter added ctm; changed read_packet 
; Sep. 14, 1999 Mark Chutter removed a spurious ENDELSE
; Apr. 21, 2000 Mark Chutter added msf file type
;
; Calling Interface:
; mode_id       long    (o)     Packet type 
; status        long    (o)     Status of PICK-Operation (see PICK-Lib)
;
; Return Value:
; Structure of type PICK_SC_RECORD
;
; Description:
; This function starts the PICKA_PK Module from the UNIX Pick Library
; and returns the received data in a structure.
; mode_id will be assigned with the mode id of the current packet.
; 
; Example:
; 
; PSTATUS = LONG(0)
; SMS     = ' '
; pick_id = long(0)
;
; ...
; SR = PICKA_PK(pick_id,PSTATUS)
; if not PSTATUS then begin
;   status=PICK_get_msg(PSTATUS,sms)
;   print,sms
; endif
; print, 'Packet Type: ',pick_id
COMMON pick, file_type, pick_lun

packet_num = 0L
packet_time = lonarr(2)
packet_time[0] = 0L
packet_time[1] =  0L
status =  0

IF file_type EQ '' THEN print, 'File type not set'
mode_id = 0 ;mode_id of 0 means any packet in read_rdm and read_cdm

CASE file_type OF

    'cdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'rdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'msf':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'ctm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'etm':pick_record = read_etm(mode_id, packet_num,  packet_time)

    'tlm':pick_record = read_tlm(mode_id, packet_num,  packet_time)

ENDCASE

return, pick_record

END
