; CLUSTER II IDL structure definitions
;
;  pick_struct.pro
;
;  Created by: Mark Chutter, UNH
;  July, 1999
;
;  Modified 
;  Aug.  9, 1999 MWC changed error field in all structures to status
;  Aug. 12, 1999 MWC added pick_sc_headers_struct
;  Oct. 19, 1999 MWC put all the pick structures in a common block
;                    rather than call batch files to define
;                    structures.  This greatly reduces overhead
;  Dec.  8, 1999 MWC added m to sc_pick_esm5_struct
;                    added staff_or_extrap to sc_pick_ehdr_struct
;                    added steps adn offsets to sc_pick_npacmo2_struct   
;  Mar. 15, 2000 MWC added srt, srt1, tspin to sc_pick_enm_struct and 
;                    sc_pick_ebm1_struct
;  Mar. 22, 2000 MWC changed init_tbl to init_table
;  May   4, 2000 MWC tspin is supposed to be a long
;  May  23, 2000 MWC added frame bits for BCI 16 structure
;  June  1, 2000 MWC added sc_id to nm1, bm1, bm3; changed bxyz which can
;                    have at most 22 data points per second (or about
;                    114 per 5.152221 seconds); added mag_time (btime
;                    is already used for something else) for magnetic
;                    field data points
;  June  7, 2000 MWC added staff_gain to sc_pick_esm1_struct
;  June 12, 2000 MWC added bciapart to sc_pick_npacmo2_struct;
;                    added mem_dump_bit to sc_pick_hdr_struct; added 
;                    dmp_addr and big_mem_dmp in sc_pick_enm_struct 
;                    and sc_pick_ebm1_struct; changed address to
;                    dmp_addr in sc_pick_ebm3_struct; changed dmp_addr 
;                    to 16 longs for all memory dumps; removed shdr
;                    from sc_pick_ebm3_struct
;  June 15, 2000 MWC decomp_data in sc_pick_bci32_struct was long, it
;                    should have been integer; changed the sizes of
;                    the arrays for scratch RAM dumps so that they are 
;                    multiples of 16 with the last few words not used
;  July  5, 2000 MWC added bx_offset and bx_step to
;                    sc_pick_npacmo2_struct for Bx stepping
;  July 10, 2000 MWC added code_type, staff_gains, and limits_by_tc to 
;                    sc_pick_esm5_struct
;  July 19, 2000 MWC changed sc_pick_gd_struct to reflect correlator changes
;  July 20, 2000 MWC added dfgm_range to sc_pick_npacmo0_struct and 
;                    sc_pick_bpacmo0_struct
;  Aug. 15, 2000 MWC changed words 14 and 15 in sc_pick_gd_struct
;  Aug. 16, 2000 MWC added dfgm_addr to dfgm in sc_pick_bpacmo0_struct
;  Aug. 17, 2000 MWC corrected NUM_CHAN2_3_DATA; changed _adr_ to _addr_
;  Aug. 21, 2000 MWC added fctmr to secondary header
;  Aug. 25, 2000 MWC compressed and uncompressed data in Pacmo0 should be
;                    unsigned, removed sc_pick_bci32_struct and added
;                    what was in this structure into arrays for NM1 Pacmo0
;  Sep.  8, 2000 MWC put big_mem_dmp into mem_dmp - having 2 similar
;                                                   things was frustrating
;  Sep. 13, 2000 MWC changed mag_time to double and added NUM_MAG
;  Sep. 19, 2000 MWC pacmo5 can have 42 gd_structs
;  Sep. 29, 2000 MWC word14 in gd_struct is now signed
;  Sep. 29, 2000 MWC NO!, pacmo5 can have 41 gd_structs, TM can lie
;  Oct.  5, 2000 MWC and I thought we would never get more than 22.5
;                    FGM samples per second; in BM1 there can be
;                    69.xxx
;  Dec. 22, 2000 MWC added raw_shdr
;  Jan.  5, 2001 MWC added data_stream
;  Jan. 16, 2001 MWC changed names and split opt_oa into 2 for
;                    esm8_struct
;  Feb.  5, 2001 MWC ishort is now a word
;  Feb. 20, 2001 MWC increased NUM_CHAN2_3_DATA by one because this
;                    failed on Jan. 31, 2001 data
;  Mar.  7, 2001 MWC added m to gd_struct
;  Apr.  4, 2001 MWC added sc_pick_npacmo4_struct and
;                    sc_pick_bpacmo4_struct
;  Aug.  9, 2001 MWC added hk to NM1, BM1, BM3, and PCK structures
;  Sep. 20, 2001 MWC qualities (sq1 and sq2) have been changed from
;                    byte to int type
;  Nov.  2, 2001 MWC replaced n_cone_steps with n_cone
;  Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
;  Feb.  8, 2002 MWC added amb GEOS time tag
;  Feb. 25, 2002 MWC added ToF overflow bits in gd_struct and
;                    bci16_struct
;  Apr. 30, 2002 MWC added time to sc_pick_amb_geos_struct
;  July 16, 2002 MWC phi and theta in Ambient GEOS are now floats
;  Feb. 24, 2003 MWC added dmp_table and ms_bci to bm3 struct
;  Apr.  9, 2003 MWC sq1 and sq2 now initialized to -9 because of one
;                    GDU TM
;  Dec. 17, 2004 MWC added flip for direction flips in ambient structs

;  This file contains the definitions of all the structures used to
;  store EDI science data for all modes.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

NUM_NPACMO0_CH0_DATA = 83
CH0_NOCOMP = 415
CH0_COMP = 664
NUM_NPACMO0_CH1_DATA = 42
NUM_NPACMO0_DFGM_DATA = 83
NUM_NPACMO0_AMB_GEOS_DATA = 83
NUM_NPACMO1_DATA = 81
NUM_NPACMO5_DATA = 82 ;was 41 before one detector mode
NUM_CHAN2_3_DATA = 2639
NUM_CHAN4_DATA = 660
NUM_BPACMO0_DFGM_DATA = 660
NUM_BPACMO0_AMB_GEOS_DATA = 660
NUM_BPACMO1_DATA = 660;was 330 before one detector mode
NUM_MAG = 350 ;that should be enough for 5.152221 seconds of data
MAX_NM1_PACMO4 = 83
MAX_BM1_PACMO4 = 1250

sc_pick_ehdr_struct = {sc_pick_ehdr_struct, $
                       packet_number: 0l, $
                       packet_time: lonarr(2), $
                       mem_dump_bit: 0b, $
                       pgai_conf: 0b, $
                       pga1_conf: 0b, $
                       pga2_conf: 0b, $
                       chan0_comp: 0b, $
                       chan1_accum: 0b, $
                       chan2_comp: 0b, $
                       chan3_comp: 0b, $
                       one_det: 0b, $
                       which_det: 0b, $ ;0 means detector 1
                       science_mode: 0b, $
                       sub_mode: 0b, $
                       wbp_cntr: 0l, $
                       peace_cnt_gun1: 0, $
                       peace_cnt_gun2: 0, $
                       mem_address: 0l, $
                       staff_or_extrap: 0, $
                       pacmo: 0b, $
                       m8sta: 0b, $
                       status: 0}

sc_pick_esm8_struct =  {sc_pick_esm8_struct, $
                        fctmr: 0l, $
                        ranged_bmag: 0U, $
                        fgm_rnot:0U, $
                        fgm_rchg:0U, $
                        xd1: 0U, $
                        yd1: 0U, $
                        beamcurrent_ref: 0U, $
                        anode: 0U, $
                        focus: 0U, $
                        wehnelt: 0U, $
                        fgm_ishort: 0U, $;< 106X frames between FGM interrupts
                        fgm_ilngf: 0U, $;> 10CX frames between FGM interrupts
                        fgm_ilngb: 0U, $;>17 BCIs between FGM interrupts
                        bci_short: 0U, $
                        bci_bdata: 0U, $
                        valid: 0}

sc_pick_esmc_struct = {sc_pick_esmc_struct, $
                       tm_step1: 0, $
                       tm_step2: 0, $
                       base_gain_hv1: 0, $
                       data_step1: 0, $
                       step_gain_hv1: 0, $
                       counts1: 0l, $
                       base_gain_hv2: 0, $
                       data_step2: 0, $
                       step_gain_hv2: 0, $
                       counts2: 0l, $
                       valid: 0}

sc_pick_esmd_struct = {sc_pick_esmd_struct, $
                       step: 0, $
                       counts29_1: 0l, $
                       counts29_2: 0l, $
                       counts30_1: 0l, $
                       counts30_2: 0l, $
                       valid: 0}

sc_pick_esm1_struct = {sc_pick_esm1_struct, $
                       fctmr: 0l, $
                       init_table: 0b, $
                       ss_limwi: 0b, $
                       energy: 0b, $
                       m: 0b, $
                       optics_state: 0b, $
                       bcnx1: 0b, $
                       bcnx2: 0b, $
                       dtdtndx: 0b, $
                       fract: 0b, $
                       sob: 0b, $
                       eeprom: 0, $
                       gdu1_cmd17: 0, $
                       perpx: 0, $
                       perpy: 0, $
                       perpz: 0, $
                       staff_gain: 0, $
                       valid: 0}

sc_pick_esm1dgx_struct = {sc_pick_esm1dgx_struct, $
                          fctmr: 0l, $
                          init_table: 0b, $
                          ss_limwi: 0b, $
                          energy: 0b, $
                          m: 0b, $
                          optics_state: 0b, $
                          bcnx1: 0b, $
                          bcnx2: 0b, $
                          dtdtndx: 0b, $
                          fract: 0b, $
                          sob: 0b, $
                          eeprom: 0, $
                          bciapart: 0b, $
                          flag_bits: 0b, $
                          steps1: 0b, $
                          steps2: 0b, $
                          gdu1_cmd17: 0, $
                          perpx: 0, $
                          perpy: 0, $
                          perpz: 0, $
                          x_offset1: 0b, $
                          y_offset1: 0b, $
                          x_offset2: 0b, $
                          y_offset2: 0b, $
                          x_step1: 0b, $
                          y_step1: 0b, $
                          x_step2: 0b, $
                          y_step2: 0b, $ 
                          valid: 0}

sc_pick_esm1dgb_struct = {sc_pick_esm1dgb_struct, $
                          fctmr: 0l, $
                          init_table: 0b, $
                          ss_limwi: 0b, $
                          energy: 0b, $
                          m: 0b, $
                          optics_state: 0b, $
                          bcnx1: 0b, $
                          bcnx2: 0b, $
                          dtdtndx: 0b, $
                          fract: 0b, $
                          sob: 0b, $
                          eeprom: 0, $
                          bciapart: 0b, $
                          flag_bits: 0b, $
                          steps1: 0b, $
                          steps2: 0b, $
                          gdu1_cmd17: 0, $
                          perpx: 0, $
                          perpy: 0, $
                          perpz: 0, $
                          bx_offset: 0, $
                          bx_step: 0, $
                          valid: 0}

sc_pick_esm5_struct = {sc_pick_esm5_struct, $
                       fctmr: 0l, $
                       init_table: 0, $
                       energy_state: 0b, $
                       m: 0b, $
                       optics_state: 0b, $
                       bcnx1: 0b, $
                       bcnx2: 0b, $
                       ndxdt: 0b, $
                       fract: 0b, $
                       sob: 0b, $
                       eeprom: 0, $
                       code_type: 0b, $
                       staff_gains: 0b, $
                       limits_by_tc: 0b, $
                       deltaflag: 0b, $
                       deltabci: 0b, $
                       wide_limit: 0b, $
                       limhi: 0b, $
                       limlo: 0b, $
                       gdu1_cmd17: 0, $
                       ave1sgnl: 0b, $
                       ave2sgnl: 0b, $
                       max1sgnl: 0b, $
                       max2sgnl: 0b, $
                       ave1bkgd: 0b, $
                       ave2bkgd: 0b, $
                       ss1_locnt: 0b, $
                       ss2_locnt: 0b, $
                       ss1_hicnt: 0b, $
                       ss2_hicnt: 0b, $
                       reverse1: 0b, $
                       reverse2: 0b, $
                       max1_678: 0b, $
                       max2_678: 0b, $
                       valid: 0, $
                       gdu1_ww_step: 0b, $
                       gdu2_ww_step: 0b}

sc_pick_esm11_struct = {sc_pick_esm11_struct, $
                        nothing: 0} ;this is a placeholder

sc_pick_esm13_struct = {sc_pick_esm13_struct, $
                        fctmr: 0, $
                        init_table: 0b, $
                        type: 0b, $
                        n_spin: 0b, $
                        n_cone: 0b, $
                        engy_start: 0b, $
                        engy_end: 0b, $
                        engy_step: 0b, $
                        engy_shift: 0b, $
                        engy_incr: 0, $
                        optics_tbl: 0, $
                        energy_tbl: 0, $
                        time_tag1: 0l, $
                        pseudobx: 0, $
                        pseudoby: 0, $
                        pseudobz: 0, $
                        fgmx: 0, $
                        fgmy: 0, $
                        fgmz: 0, $
                        time_tag2: 0l, $
                        valid: 0}

sc_pick_eshd_struct = {sc_pick_eshd_struct, $
                       m8: sc_pick_esm8_struct, $
                       mc: sc_pick_esmc_struct, $
                       md: sc_pick_esmd_struct, $
                       m1: sc_pick_esm1_struct, $
                       m1dgx: sc_pick_esm1dgx_struct, $
                       m1dgb: sc_pick_esm1dgb_struct, $
                       m5: sc_pick_esm5_struct, $
                       m13: sc_pick_esm13_struct, $
                       fctmr: 0L, $
                       status: 0}

sc_pick_dfgm_struct = {sc_pick_dfgm_struct, $
                       b_z: 0, $
                       bcomp: 0, $
                       acc: 0, $
                       bcomp_0: 0L}

sc_pick_amb_geos_struct = {sc_pick_amb_geos_struct, $
                           time: 0.D, $
                           theta: 0., $
                           phi: 0., $
                           bz_gz: 0, $
                           b_perp: 0, $
                           flip: 0, $
                           energy: 0, $
                           zperp: 0, $
                           yperp: 0, $
                           data29_1: 0, $
                           data29_2: 0}

sc_pick_bci16_struct  = {sc_pick_bci16_struct , $
                         atime: lonarr(2), $
                         beam_time1: 0.D, $
                         beam_time2: 0.D, $
                         t1: 0l, $ ;  /* Time of Flight for gun 1 */
                         t1m2: 0, $ ; /* ToF for gun 1 - ToF for gun 2 */
                         tof_over: 0, $ ;ToF = $FFF overflow
                         dtof_p_over: 0, $ ;dToF = $1FF positive overflow
                         dtof_n_over: 0, $ ;ToF = $200 negative overflow
                         vax1: 0, $
                         vay1: 0, $
                         vax2: 0, $
                         vay2: 0, $
                         i1: 0b, $ ;  /* index for detector 1 */
                         i2: 0b, $ ;  /* index for detector 2 */
                         frame1: 0b, $
                         frame2: 0b, $
                         sq1: -9, $ ; /* quality bits for detector 1 */
                         sq2: -9, $ ; /* quality bits for detector 2 */
                         e: 0b, $ ; /* energy bit: 0=>1 KeV, 1=>500 eV) */
                         m: 0b, $ ; /* correlator parameter */
                         nnn: 0b} ; /* correlator parameter */

sc_pick_gd_struct = {sc_pick_gd_struct, $
                     atime: lonarr(2), $
                     beam_time1: 0.D, $
                     beam_time2: 0.D, $
                     t1: 0l, $ ;  /* Time of Flight for gun 1 */
                     t1m2: 0, $ ; /* ToF for gun 1 - ToF for gun 2 */
                     tof_over: 0, $ ;ToF = $FFF overflow
                     dtof_p_over: 0, $ ;dToF = $1FF positive overflow
                     dtof_n_over: 0, $ ;ToF = $200 negative overflow
                     vax1: 0, $
                     vay1: 0, $
                     vax2: 0, $
                     vay2: 0, $
                     word14_1: 0, $
                     word14_2: 0, $
                     word15_1: 0U, $
                     word15_2: 0U, $
                     i1: 0b, $  ; /* index for detector 1 */
                     i2: 0b, $  ; /* index for detector 2 */
                     sq1: -9, $ ; /* quality bits for detector 1 */
                     sq2: -9, $ ; /* quality bits for detector 2 */
                     e: 0b, $   ; /* energy bit: 0=>1 KeV, 1=>500 eV) */
                     m: 0b, $ ; /* correlator parameter */
                     nnn: 0b, $ ; /* correlator parameter */
                     max_addr1: 0b, $
                     max_addr2: 0b, $
                     frame1: 0b, $
                     frame2: 0b}

sc_pick_npacmo5_struct = {sc_pick_npacmo5_struct, $
                          time_tag: 0l, $
                          data_count: 0, $
                          data: replicate({sc_pick_gd_struct}, $
                                          NUM_NPACMO5_DATA), $
                          status: 0}

sc_pick_npacmo4_struct = {sc_pick_npacmo4_struct, $
                          pga1_conf: 0b, $
                          timetag32: 0l, $
                          data_count: 0, $
                          conpc: fltarr(MAX_NM1_PACMO4), $
                          gd1pc: fltarr(MAX_NM1_PACMO4), $
                          gd2pc: fltarr(MAX_NM1_PACMO4), $
                          vol28: fltarr(MAX_NM1_PACMO4), $
                          mux: 0, $
                          timetag64: 0l, $
                          gdu_timetags: lonarr(16), $
                          status: 0}

sc_pick_npacmo2_struct = {sc_pick_npacmo2_struct, $
                          time_tag: 0L, $
                          peak_offset: intarr(4), $
                          cdata: intarr(4,16,7), $
                          xd1_offset: 0, $
                          yd1_offset: 0, $
                          xd2_offset: 0, $
                          yd2_offset: 0, $
                          xd1_step: 0, $
                          yd1_step: 0, $
                          xd2_step: 0, $
                          yd2_step: 0, $
                          time_tag2: 0L, $
                          RAM_bcis: 0, $
                          bciapart: 0b, $
                          bx_offset: 0, $
                          bx_step: 0, $
                          status: 0}

sc_pick_npacmo1_struct = {sc_pick_npacmo1_struct, $
                          time_tag: 0l, $
                          data_count: 0, $
                          data: replicate({sc_pick_bci16_struct}, $
                                          NUM_NPACMO1_DATA), $
                          status: 0}

sc_pick_npacmo0_struct = {sc_pick_npacmo0_struct, $
                          ch0_data_word: 0l, $
                          ch0_time_tag: 0l, $
                          ch0_bci_cnt: 0, $
                          ch0_comp: uintarr(CH0_COMP), $
                          ch0_decomp: uintarr(CH0_COMP), $
                          ch0_range: bytarr(CH0_COMP), $
                          ch0_sample: intarr(CH0_NOCOMP), $
                          ch1_source: 0l, $
                          ch1_time_tag: 0l, $
                          ch1_bci_cnt: 0, $
                          ch1_data: intarr(NUM_NPACMO0_CH1_DATA), $
                          data_flag: 0, $
                          dfgm_time_tag: 0L, $
                          dfgm_count: 0, $
                          dfgm_range: 0, $
                          dfgm: replicate({sc_pick_dfgm_struct}, $
                                          NUM_NPACMO0_DFGM_DATA), $
                          amb_geos_time_tag: 0L, $
                          amb_geos_count: 0, $
                          RAM_init: uintarr(4), $
                          addresses: ulonarr(8), $
                          amb_geos: replicate({sc_pick_amb_geos_struct}, $
                                              NUM_NPACMO0_AMB_GEOS_DATA), $
                          status: 0}

sc_pick_bpacmo4_struct = {sc_pick_bpacmo4_struct, $
                          pga1_conf: 0b, $
                          timetag_2_3: 0l, $
                          data_count: 0, $
                          conpc: fltarr(MAX_BM1_PACMO4), $
                          gd1pc: fltarr(MAX_BM1_PACMO4), $
                          gd2pc: fltarr(MAX_BM1_PACMO4), $
                          vol28: fltarr(MAX_BM1_PACMO4), $
                          mux: 0, $
                          timetag_4: 0l, $
                          gdu_timetags: lonarr(16), $
                          status: 0}

sc_pick_bpacmo1_struct = {sc_pick_bpacmo1_struct, $
                          time_tag: 0L, $
                          data_count: 0, $
                          data: replicate({sc_pick_gd_struct}, $
                                          NUM_BPACMO1_DATA), $
                          status: 0}

sc_pick_bpacmo0_struct = {sc_pick_bpacmo0_struct, $
                          mem_dmp: intarr(143), $
                          chan2_addr: 0L, $
                          chan3_addr: 0L, $
                          chan2_3_timetag: 0L, $
                          chan2_3_cnt:0, $
                          chan2_data: intarr(NUM_CHAN2_3_DATA), $
                          chan3_data: intarr(NUM_CHAN2_3_DATA), $
                          chan2_3_data: intarr(NUM_CHAN2_3_DATA), $
                          chan2_comp_data: uintarr(NUM_CHAN2_3_DATA), $
                          chan2_decomp_data: uintarr(NUM_CHAN2_3_DATA), $
                          chan3_comp_data: uintarr(NUM_CHAN2_3_DATA), $
                          chan3_decomp_data: uintarr(NUM_CHAN2_3_DATA), $
                          chan4_addr: 0L, $
                          chan4_timetag: 0L, $
                          chan4_cnt: 0L, $
                          chan4_data: intarr(NUM_CHAN4_DATA), $
                          dfgm_addr: lonarr(5), $
                          data_flag: 0, $
                          dfgm_time_tag: 0L, $
                          dfgm_count: 0, $
                          dfgm_range: 0, $
                          dfgm: replicate({sc_pick_dfgm_struct}, $
                                          NUM_BPACMO0_DFGM_DATA), $
                          amb_geos_time_tag: 0L, $
                          amb_geos_count: 0, $
                          RAM_init: uintarr(4), $
                          addresses: ulonarr(8), $
                          amb_geos: replicate({sc_pick_amb_geos_struct}, $
                                              NUM_BPACMO0_AMB_GEOS_DATA), $
                          status: 0 $
}

sc_pick_enm_struct = {sc_pick_enm_struct, $
                      sc_id: 0, $
                      data_stream: 0B, $
                      hdr: {sc_pick_ehdr_struct}, $
                      shdr: {sc_pick_eshd_struct}, $
                      raw_shdr: bytarr(32), $
                      bhk: intarr(32), $
                      mag_time: dblarr(NUM_MAG), $
                      bxyz: fltarr(NUM_MAG, 3), $ 
                      srt: lonarr(2), $
                      srt1: lonarr(2), $
                      tspin: 0L, $
                      dmp_addr: lonarr(16), $
                      mem_dmp: intarr(454), $
                      pacmo0: {sc_pick_npacmo0_struct}, $
                      pacmo1: {sc_pick_npacmo1_struct}, $
                      pacmo2: {sc_pick_npacmo2_struct}, $
                      pacmo4: {sc_pick_npacmo4_struct}, $
                      pacmo5: {sc_pick_npacmo5_struct}, $
                      bm2_words: intarr(6), $
                      hk: sc_pick_hk_struct, $
                      status:0}

sc_pick_ebm1_struct = {sc_pick_ebm1_struct, $
                       sc_id: 0, $
                       data_stream: 0B, $ ;byte 13 of DDS header
                       hdr: {sc_pick_ehdr_struct}, $
                       shdr: {sc_pick_eshd_struct}, $
                       raw_shdr: bytarr(32), $
                       bhk: intarr(32), $
                       mag_time: dblarr(NUM_MAG), $
                       bxyz: fltarr(NUM_MAG, 3), $
                       srt: lonarr(2), $
                       srt1: lonarr(2), $
                       tspin: 0L, $
                       dmp_addr: lonarr(16), $
                       mem_dmp: intarr(3430), $
                       pacmo0: {sc_pick_bpacmo0_struct}, $
                       pacmo1: {sc_pick_bpacmo1_struct}, $
                       pacmo4: {sc_pick_bpacmo4_struct}, $
                       hk: sc_pick_hk_struct, $
                       status:0}

sc_pick_ebm3_struct = {sc_pick_ebm3_struct, $
                       sc_id: 0, $
                       data_stream: 0B, $ ;byte 13 of DDS header
                       hdr: {sc_pick_ehdr_struct}, $
                       dmp_addr: lonarr(16), $
                       dmp_table: 0, $;scratch RAM dump table
                       ms_bci: 0, $;scratch RAM 2 (0) or 4 (1) ms BCI
                       mem_dmp: intarr(11280), $ ;only 11278 used
                       rest: intarr(280), $
                       hk: sc_pick_hk_struct, $
                       status:0}

sc_pick_pck_struct = {sc_pick_pck_struct, $
                      packet_type: 0L, $
                      packet_number: 0L, $
                      packet_time: lonarr(2), $
                      packet_length:0L, $
                      data: intarr(MAX_PACKET_SIZE/2), $
                      hk: sc_pick_hk_struct, $
                      status: 0}

sc_pick_headers_struct = {sc_pick_headers_struct, $
                          data_stream: 0B, $ ;byte 13 of DDS header
                          hdr: {sc_pick_ehdr_struct}, $
                          shdr: {sc_pick_eshd_struct}, $
                          status: 0}


