PRO pick_shk_init, SNAME, FNAME, rename_ftp = rename_ftp
; CLUSTER II IDL Procedure
;
; Abstract: open spacecraft housekeeping data file
;
; created by: Mark Chutter
; Mar. 14, 2000
;
; Modified: 
; May   4, 2000 MWC Tspin is supposed to be a long
; Sep.  7, 2000 MWC now handles FTP format and added rename_ftp keyword
; Mar. 13, 2002 MWC commented out print statement when file not found
;
; Calling Interface:
; SNAME         char    (i)     Type of data as text (ARCHIVE,RDM,RTA)
; FNAME         char    (i)     data file name
;
; Return Value:
;
; Description:
; This opens an RDM spacecraft housekeeping file.
;
; Example:
; 
; SNAME = 'rdm'
; FNAME = '000115sh.1a1'
;
; ...
; PICK_SHK_INIT(SNAME,FNAME)
; status= PICKA_SC(sc_pick_id,PSTATUS)
; ...
;
COMMON shk, pick_shk_lun
COMMON last_sun_data, last_srp, last_Tspin

last_srp = lonarr(2)
last_Tspin = 4000000L
SFDU_label = bytarr(20)
SFDU_length = 0L

SNAME = STRLOWCASE(SNAME)

file_type = SNAME
openr, pick_shk_lun, FNAME, /get_lun, error = err
IF (err NE 0) THEN BEGIN
;    print, 'Could not find SC_HK file!'
    pick_shk_lun = -3 ;-3 is not a valid LUN so I use it for this error
    return
ENDIF

IF (file_type EQ 'ftp') THEN BEGIN
    name_check = strpos(strlowcase(fname), '.edi')
    IF keyword_set(rename_ftp) AND name_check GT 0 THEN BEGIN
        line = ''
        last_slash = rstrpos(fname, '/')
        IF last_slash EQ -1 THEN file_path = '' $
        ELSE file_path = strmid(fname, 0, last_slash+1)
        readf, pick_lun, line
        readf, pick_lun, line ;second line contains SC ID
        line = strlowcase(line)
        tmp = strpos(line,'cluster_') + 8
        sc_id = strmid(line, tmp, 1) ;this should be the SC ID
        readf, pick_shk_lun, line ;third line contains data source (EDI or SC)
        line = strlowcase(line)
        tmp = strpos(line,'=') + 1
        source = strmid(line, tmp)
        semi = strpos(source, ';');replace the ';' with ' '
        strput, source, ' ', semi
        source = strtrim(source, 2)
        readf, pick_shk_lun, line ;fourth line has data type (NSD,BSD, or HKD)
        line = strlowcase(line)
        tmp = strpos(line,'=') + 1
        type = strmid(line, tmp)
        semi = strpos(type, ';');replace the ';' with ' '
        strput, type, ' ', semi
        type = strtrim(type, 2)
        IF type EQ 'hkd' AND source EQ 'sc' THEN type = 'shk'
        readf, pick_shk_lun, line
        readf, pick_shk_lun, line ;sixth line contains start time
        line = strlowcase(line)
        tmp = strpos(line, '20')
        time_stamp = strmid(line, tmp)
        len = strlen(time_stamp)
        time_stamp1 = strmid(time_stamp, 0, len-2)
        colon = strpos(time_stamp1, ':');replace the 2 ':' with '_'
        strput, time_stamp1, '_', colon
        colon = strpos(time_stamp1, ':')
        strput, time_stamp1, '_', colon
        outname = file_path + 'cl' + sc_id + '_' + time_stamp1 + '.' + type
        command = 'mv ' + fname + ' ' + outname
        close, pick_shk_lun
        spawn, command
        openr, pick_shk_lun, outname, error = err
        IF (err NE 0) THEN BEGIN
            print, 'Could not find SC_HK file!'
            pick_shk_lun = -3 ;-3 is not a valid LUN so I use it for this error
            return
        ENDIF
    ENDIF
    readu, pick_shk_lun, SFDU_label ;for the entire packet
    readu, pick_shk_lun, SFDU_label ;for the first LVO - the acknowledgement
    SFDU_length = 0L
    FOR i = 0, 7 DO $
      SFDU_length = SFDU_length + 10L^(7-i) * (LONG(SFDU_label[12+i]) - 48L)
    ack = bytarr(SFDU_length)
    readu, pick_shk_lun, ack
    SFDU_length = 0L
    readu, pick_shk_lun, SFDU_label ;for the second LVO - the catalogue entry
    FOR i = 0, 7 DO $
      SFDU_length = SFDU_length + 10L^(7-i) * (LONG(SFDU_label[12+i]) - 48L)
    catalogue = bytarr(SFDU_length)
    readu, pick_shk_lun, catalogue
    readu, pick_shk_lun, SFDU_label ;for the third LVO - the data

    file_type = 'rdm'; now treat file like RDM
ENDIF

return

END
