PRO pick_init, SNAME, FNAME, $
               read_file = read_file, rename_ftp = rename_ftp, error = error
; CLUSTER II IDL Procedure
;
; Abstract: Initialize the Pick Library and open data file
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; Nov. 22, 1998
;
; Modified: 
; Mar.  4, 1999 Mark Chutter added PICK_LIB environment variable
; July  8, 1999 Mark Chutter replaced CALL_EXTERNAL
; July 22, 1999 Mark Chutter added ctm code
; Feb. 22, 2000 MWC added hk_structs
; Mar. 13, 2000 MWC added Spacecraft HK
; Mar. 15, 2000 MWC added more Spacecraft HK stuff
; May   4, 2000 MWC Tspin is supposed to be a long
; Jul. 10, 2000 MWC added stream keyword when opening a CTM file under 
;                   VMS
; July 18, 2000 MWC added possibility of having no SC_HK data
; Aug. 10, 2000 MWC added rename_ftp keyword which is used to
;                   translate an ftp type file name to something
;                   meaningful, namely:cl#_YYYY-MM-DDtHH_MM_SSz.ext
;                   where ext is one of nsd, bsd, hkd, shk
; Aug. 28, 2000 MWC changed header length for ctm; added ctm_sat_id
;                   because the SC ID is not a part of telemetry; I
;                   get the ID from the file name which will break if
;                   someone changes the way ctm files are named
; Sep.  5, 2000 MWC file type of FTP is changed to RDM after
;                   initialization changed order
; Sep.  7, 2000 MWC if the file type is FTP, try to find a matching SC 
;                   HK file
; Sep. 13, 2000 MWC if the CL_MAG environment variable is set, tries to
;                   find a calibrated FGM file
; Sep. 19, 2000 MWC added mag_lun common and set pick_mag_lun to -3
;                   if no FGM data
; Oct.  4, 2000 MWC now automatically look for a calibrated FGM file
; Nov.  9, 2000 MWC initialize pick_shk_lun
; Dec,  6, 2000 MWC now you can use the FGM_CALIB environment variable
;                   to decide whether to read calibrated or
;                   uncalibrated FGM
; Dec.  8, 2000 MWC was checking ERR which did not exist, I think I
;                   did and old cut-n-paste booboo
; Dec. 20, 2000 MWC changed the use of FGM_CALIB env variable: if it
;                   is not set or is 'YES', then use calibrated data;
;                   otherwise it should be the path to a calibration
;                   file. 
; Jan. 12, 2000 MWC pick_init now tries to look for an FGM file for
;                   RDM and MSF types
; Feb.  1, 2001 MWC If there is no shk file with the same start time
;                   as the EDI science file for 'FTP' files, then look
;                   for a file that starts at the beginning of the day.
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Apr. 23, 2001 MWC added error keyword
; Aug.  9, 2001 MWC added file type check
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; 
; Calling Interface:
; SNAME         char    (i)     Type of data as text (ARCHIVE,RDM,RTA)
; FNAME         char    (i)     data file name
;
; Return Value:
;
; Description:
; This function initializes the pick library and all successive PICK calls
; by setting the data source and the type of data to read from.
; This call should be the first one before any other PICKxx calls.
; To close a data file and open a new one in the same session use the 
; PICK_CLOSE function before a subsequent call to PICK_INIT.
;
; Example:
; 
; SNAME = 'ARCHIVE'
; FNAME = 'DMV1002.TM'
;
; ...
; PICK_INIT(SNAME,FNAME)
; status= PICKA_SC(sc_pick_id,PSTATUS)
; ...
;
@hk_struct
@pick_struct
@pick_const

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

COMMON hk_structs, sc_pick_ana_sensor_struct, sc_pick_dig_sensor_struct, sc_pick_sensor_struct, sc_pick_gdu_01_struct, sc_pick_gdu_23_struct, sc_pick_gdu_45_struct, sc_pick_gdu_67_struct, sc_pick_gdu_struct, sc_pick_I_V_struct, sc_pick_hk_struct
COMMON pick, file_type, pick_lun
COMMON pick_buffer, pick_buffer, pick_buf_ptr
COMMON shk, pick_shk_lun
COMMON last_sun_data, last_srp, last_Tspin
COMMON ctm_sat_id, ctm_sat_id
COMMON mag_lun, pick_mag_lun

error = 1
last_srp = lonarr(2)
last_Tspin = 4000000L
SFDU_label = bytarr(20)
SFDU_length = 0L
pick_mag_lun = -3
pick_shk_lun = -3

on_ioerror, file_error

SNAME = STRLOWCASE(SNAME)

file_type = SNAME
IF file_type EQ '' THEN BEGIN
    print, 'File type not set'
    return
ENDIF

; If the file is a ctm file, read the file header, which is of no value
IF (file_type EQ 'ctm') THEN BEGIN
    ;BUGGER, this will not work if the naming convention changes
    last_slash = rstrpos(FNAME, '/')
    IF last_slash EQ -1 THEN $
      ctm_sat_id = fix(strmid(FNAME, 5, 1)) $
    ELSE ctm_sat_id = fix(strmid(strmid(FNAME, last_slash), 7, 1))
;2 bytes for VMS record length, 2 bytes for VMS seg code, 184 bytes for header
    header = bytarr(186);changed from 188 8-26-2000
    IF !version.os_family EQ 'vms' THEN BEGIN
        openr, pick_lun, FNAME, /get_lun, /stream ;ignore VMS file info
    ENDIF ELSE BEGIN
        openr, pick_lun, FNAME, /get_lun
    ENDELSE
    readu, pick_lun, header
ENDIF ELSE openr, pick_lun, FNAME, /get_lun

; The following relies on having a file structure like that of a
; Cluster CDROM, i.e., the spacecraft housekeeping data should be in a 
; directory ../hkd_X from the other data files where X is the
; spacecraft ID.
IF (file_type EQ 'rdm') THEN BEGIN
    chopped = str_sep(FNAME, '/')
    short_name = chopped(n_elements(chopped)-1)
    len = strlen(short_name)
    sc_id = strmid(short_name, len-1)
    strput, short_name, 's', 6
    strput, short_name, 'h', 7
    shk_path = ''
    FOR i = 0, n_elements(chopped)-3 DO $
      shk_path = shk_path + chopped[i] + '/' 
    shk_path = shk_path + 'hkd_' + sc_id + '/'
    shk_name = shk_path + short_name
    pick_shk_init, sname, shk_name
ENDIF

IF file_type EQ 'msf' OR $
  file_type EQ 'rdm' THEN BEGIN
    cl_mag = getenv('CL_MAG')
    IF cl_mag NE '' THEN BEGIN
        fgm_cal = getenv('FGM_CALIB')
        IF fgm_cal EQ 'YES' OR $
          fgm_cal EQ '' THEN mag_suffix = '_SCS.mag' $
        ELSE mag_suffix = '_FS.mag'
        mag_bits = str_sep(fname, '/')
        num_mag_bits = n_elements(mag_bits)
        mag_name = mag_bits[num_mag_bits-1]
        sc_id = strmid(mag_name, 11, 1)
        year='20' + strmid(mag_name, 0, 2)
        month=strmid(mag_name, 2, 2)
        day=strmid(mag_name, 4, 2)
        full_mag_name = cl_mag + 'sc' + sc_id + '/C' + sc_id + '_' + $
          year + month + day + mag_suffix
        pick_fgm_init, full_mag_name
    ENDIF
ENDIF

IF (file_type EQ 'ftp') THEN BEGIN
    name_check = strpos(strlowcase(fname), '.edi')
    IF keyword_set(rename_ftp) AND name_check GT 0 THEN BEGIN
        line = ''
        last_slash = rstrpos(fname, '/')
        IF last_slash EQ -1 THEN file_path = '' $
        ELSE file_path = strmid(fname, 0, last_slash+1)
        readf, pick_lun, line
        readf, pick_lun, line ;second line contains SC ID
        line = strlowcase(line)
        tmp = strpos(line,'cluster_') + 8
        sc_id = strmid(line, tmp, 1) ;this should be the SC ID
        readf, pick_lun, line ;third line contains data source (EDI or SC)
        line = strlowcase(line)
        tmp = strpos(line,'=') + 1
        source = strmid(line, tmp)
        semi = strpos(source, ';');replace the ';' with ' '
        strput, source, ' ', semi
        source = strtrim(source, 2)
        readf, pick_lun, line ;fourth line contains data type (NSD,BSD, or HKD)
        line = strlowcase(line)
        tmp = strpos(line,'=') + 1
        type = strmid(line, tmp)
        semi = strpos(type, ';');replace the ';' with ' '
        strput, type, ' ', semi
        type = strtrim(type, 2)
        IF type EQ 'hkd' AND source EQ 'sc' THEN type = 'shk'
        readf, pick_lun, line
        readf, pick_lun, line ;sixth line contains start time
        line = strlowcase(line)
        tmp = strpos(line, '20')
        time_stamp = strmid(line, tmp)
        len = strlen(time_stamp)
        time_stamp1 = strmid(time_stamp, 0, len-2)
        colon = strpos(time_stamp1, ':');replace the 2 ':' with '_'
        strput, time_stamp1, '_', colon
        colon = strpos(time_stamp1, ':')
        strput, time_stamp1, '_', colon
        outname = file_path + 'cl' + sc_id + '_' + time_stamp1 + '.' + type
        command = 'mv ' + fname + ' ' + outname
        close, pick_lun
        spawn, command
        openr, pick_lun, outname
    ENDIF
    readu, pick_lun, SFDU_label ;for the entire packet
    readu, pick_lun, SFDU_label ;for the first LVO - the acknowledgement
    SFDU_length = 0L
    FOR i = 0, 7 DO $
      SFDU_length = SFDU_length + 10L^(7-i) * (LONG(SFDU_label[12+i]) - 48L)
    ack = bytarr(SFDU_length)
    readu, pick_lun, ack
    SFDU_length = 0L
    readu, pick_lun, SFDU_label ;for the second LVO - the catalogue entry
    FOR i = 0, 7 DO $
      SFDU_length = SFDU_length + 10L^(7-i) * (LONG(SFDU_label[12+i]) - 48L)
    catalogue = bytarr(SFDU_length)
    readu, pick_lun, catalogue
    readu, pick_lun, SFDU_label ;for the third LVO - the data

    cl_mag = getenv('CL_MAG')
    IF cl_mag NE '' THEN BEGIN
        fgm_cal = getenv('FGM_CALIB')
        IF fgm_cal EQ 'YES' OR $
          fgm_cal EQ '' THEN mag_suffix = '_SCS.mag' $
        ELSE mag_suffix = '_FS.mag'
        mag_bits = str_sep(fname, '/')
        num_mag_bits = n_elements(mag_bits)
        mag_name = mag_bits[num_mag_bits-1]
        sc_id = strmid(mag_name, 2, 1)
        year=strmid(mag_name, 4, 4)
        month=strmid(mag_name, 9, 2)
        day=strmid(mag_name, 12, 2)
        full_mag_name = cl_mag + 'sc' + sc_id + '/C' + sc_id + '_' + $
          year + month + day + mag_suffix
        pick_fgm_init, full_mag_name
    ENDIF

    ;find and initialize SC HK
    len = strlen(FNAME)
    shk_name = FNAME
    strput, shk_name, 'shk', len-3
    pick_shk_init, 'ftp', shk_name
;If this fails, see if there is a file from start of day
    IF pick_shk_lun EQ -3 THEN BEGIN
        strput, shk_name, '00_00_00', len-13
        pick_shk_init, 'ftp', shk_name
        IF pick_shk_lun NE -3 THEN print, 'Using shk file from start of day.'
    ENDIF
    file_type = 'rdm'; now treat file like RDM
ENDIF

IF keyword_set(read_file) THEN BEGIN
    file_stat = fstat(pick_lun)
    pick_buffer = bytarr(file_stat.size)
    readu, pick_lun, pick_buffer
    pick_buf_ptr = 0L
ENDIF

return

file_error:
error = EOF
return

END
