PRO pick_hk_init, hk_f_type, file_name
; CLUSTER II IDL Procedure
;
; Abstract: Initialize the Pick Library and open EDI HK data file
;
; created by: Mark Chutter
; Nov. 28, 2000
;
; Modified: 
; 
; Calling Interface:
; hk_f_type      char    (i)     Type of data as text (RDM, FTP)
; file_name      char    (i)     data file name
;
; Return Value:
;
; Description:
; This function initializes the pick library and all successive PICK calls
; by setting the data source and the type of data to read from.
; This routine is not to be used with MSFs, rather it should be used
; when EDI HK is in a separate file.
;
; Example:
; 
; hk_f_type = 'FTP'
; file_name = 'DMV1002.TM'
;
; ...
; PICK_INIT(hk_file_type,file_name)
; status= PICKN_HK(sc_pick_id,PSTATUS)
; ...
;
@hk_struct

COMMON hk_structs, sc_pick_ana_sensor_struct, sc_pick_dig_sensor_struct, sc_pick_sensor_struct, sc_pick_gdu_01_struct, sc_pick_gdu_23_struct, sc_pick_gdu_45_struct, sc_pick_gdu_67_struct, sc_pick_gdu_struct, sc_pick_I_V_struct, sc_pick_hk_struct
COMMON pick_hk, hk_file_type, pick_hk_lun
COMMON ctm_sat_id, ctm_sat_id

SFDU_label = bytarr(20)
SFDU_length = 0L

hk_file_type = strlowcase(hk_f_type)

; If the file is a ctm file, read the file header, which is of no value
IF (hk_file_type EQ 'ctm') THEN BEGIN
    ;BUGGER, this will not work if the naming convention changes
    last_slash = rstrpos(file_name, '/')
    IF last_slash EQ -1 THEN $
      ctm_sat_id = fix(strmid(file_name, 5, 1)) $
    ELSE ctm_sat_id = fix(strmid(strmid(file_name, last_slash), 7, 1))
;2 bytes for VMS record length, 2 bytes for VMS seg code, 184 bytes for header
    header = bytarr(186);changed from 188 8-26-2000
    IF !version.os_family EQ 'vms' THEN BEGIN
        openr, pick_hk_lun, file_name, /get_lun, /stream ;ignore VMS file info
    ENDIF ELSE BEGIN
        openr, pick_hk_lun, file_name, /get_lun
    ENDELSE
    readu, pick_hk_lun, header
ENDIF ELSE openr, pick_hk_lun, file_name, /get_lun

IF (hk_file_type EQ 'ftp') THEN BEGIN
    readu, pick_hk_lun, SFDU_label ;for the entire packet
    readu, pick_hk_lun, SFDU_label ;for the first LVO - the acknowledgement
    SFDU_length = 0L
    FOR i = 0, 7 DO $
      SFDU_length = SFDU_length + 10L^(7-i) * (LONG(SFDU_label[12+i]) - 48L)
    ack = bytarr(SFDU_length)
    readu, pick_hk_lun, ack
    SFDU_length = 0L
    readu, pick_hk_lun, SFDU_label ;for the second LVO - the catalogue entry
    FOR i = 0, 7 DO $
      SFDU_length = SFDU_length + 10L^(7-i) * (LONG(SFDU_label[12+i]) - 48L)
    catalogue = bytarr(SFDU_length)
    readu, pick_hk_lun, catalogue
    readu, pick_hk_lun, SFDU_label ;for the third LVO - the data
    hk_file_type = 'rdm'
ENDIF

return
END
