FUNCTION pick_hdrs, mode_id, status
; CLUSTER II IDL Procedure
;
; Abstract: Pick the next available science packet of any type
;
; created by: Mark Chutter
; Aug. 12, 1999
;
; modified: 
; Feb. 20, 2001 MWC added MSF as one of the file types
;         
; Calling Interface:
; mode_id       long    (o)     Science Mode 
; status        long    (o)     Status of PICK-Operation (see PICK-Lib)
;
; Return Value:
; Structure of type sc_pick_headers_struct
;
; Description:
; This function looks for the next valid EDI science packet and
; returns only the header and secondary header.
; mode_id will be assigned with the mode id of the current SC packet.
; 
; Example:
; 
; PSTATUS = LONG(0)
; SMS     = ' '
; sc_pick_id = long(0)
;
; ...
; SR = PICK_hdrs(sc_pick_id,PSTATUS)
; if not PSTATUS then begin
;   status=PICK_get_msg(PSTATUS,sms)
;   print,sms
; endif
; print, 'Science Packet Type: ',sc_pick_id
COMMON pick, file_type, pick_lun

packet_num = 0L
packet_time = lonarr(2)
packet_time[0] = 0L
packet_time[1] =  0L
status =  0


IF file_type EQ '' THEN print, 'File type not set'

mode_id = 2 ;mode_id of 2 means any science packet in read_rdm and read_cdm

CASE file_type OF

    'msf':pick_record = read_headers(mode_id, packet_num,  packet_time)

    'cdm':pick_record = read_headers(mode_id, packet_num,  packet_time)

    'rdm':pick_record = read_headers(mode_id, packet_num,  packet_time)

    'ctm':pick_record = read_headers(mode_id, packet_num,  packet_time)

ENDCASE

status = pick_record.status
IF pick_record.status GT 0 THEN BEGIN
mode_id = pick_record.status
ENDIF

return, pick_record

END
