FUNCTION nm1_pacmo2_fill, packet
; CLUSTER II IDL Function
;
; Abstract: fill an EDI nm1_pacmo2 data structure
;
; Created by: Mark Chutter, UNH 
; June 29, 1999
;
; Modified:
; July 20, 1999 Mark Chutter added time_tag2 and RAM_bcis
; Aug.  9, 1999 MWC changed error field to status
; Oct. 19, 1999 MWC used common block for structure definitions
; June  6, 2000 MWC had j going to 16 rather than 15
; July  5, 2000 MWC added bx_offset and bx_step for Bx stepping
; Jul.  5, 2000 MWC was checking wrong bit for bx stepping
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
;
; Calling Interface:
; packet bytarr              (i) EDI science packet
;
; Return Value:
; A sc_pick_npacmo2_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; nm1_pacmo2_fill fills a nominal mode 1, pacmo 2 data structure.  It
; is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

PACMO2_PEAKS_START = 42
PACMO2_CDATA_START = 50
offset = 0

pacmo2 = sc_pick_npacmo2_struct
pacmo2.status = 1
pacmo2.time_tag = long(packet[40]) * '100'xL + long(packet[41])

offset = PACMO2_PEAKS_START

FOR i = 0, 3 DO BEGIN
    pacmo2.peak_offset[i] = fix(packet[offset]) * '100'x + $
      fix(packet[offset+1])
    offset = offset+2
ENDFOR

offset = PACMO2_CDATA_START

FOR i = 0, 3 DO BEGIN
    FOR j = 0, 15 DO BEGIN
        FOR k = 0, 6 DO BEGIN
            pacmo2.cdata[i, j, k] = fix(packet[offset]) * '100'x + $
              fix(packet[offset+1])
            offset =  offset+2
        ENDFOR
    ENDFOR
ENDFOR
bx_stepping = packet[19] AND '2'x
IF bx_stepping EQ 0 THEN BEGIN
    pacmo2.xd1_offset = fix(packet[946]) * '100'x + fix(packet[947])
    pacmo2.yd1_offset = fix(packet[948]) * '100'x + fix(packet[949])
    pacmo2.xd2_offset = fix(packet[950]) * '100'x + fix(packet[951])
    pacmo2.yd2_offset = fix(packet[952]) * '100'x + fix(packet[953])
    pacmo2.xd1_step = fix(packet[954]) * '100'x + fix(packet[955])
    pacmo2.yd1_step = fix(packet[956]) * '100'x + fix(packet[957])
    pacmo2.xd2_step = fix(packet[958]) * '100'x + fix(packet[959])
    pacmo2.yd2_step = fix(packet[960]) * '100'x + fix(packet[961])
ENDIF ELSE BEGIN
    pacmo2.bx_offset = fix(packet[946]) * '100'x + fix(packet[947])
    pacmo2.bx_step = fix(packet[954]) * '100'x + fix(packet[955])
ENDELSE

pacmo2.time_tag2 = long(packet[962]) * '100'xL + long(packet[963])
pacmo2.RAM_bcis = fix(packet[964]) * '100'x + fix(packet[965])

return, pacmo2
END
