FUNCTION nm1_fill, packet, packet_number, packet_time, sc_id
; CLUSTER II IDL Function
;
; Abstract: fill an EDI nm1 data structure
;
; Created by: Mark Chutter, UNH 
; June 29, 1999
;
; Modified:
; Aug.  9, 1999 MWC changed error field to status
; Oct. 19, 1999 MWC used common block for structure definitions
; Jan. 20, 2000 MWC check return value from filling shdr
; June 12, 2000 MWC added ugly code to get bciapart into pacmo2;
;                   fill dmp_addr and big_mem_dmp if mem_dump_bit is set
; Aug.  3, 2000 MWC changed byte order of dump address
; Aug. 30, 2000 MWC now copy status from pacmo's into nm1.status
; Sep.  8, 2000 MWC put big_mem_dmp into mem_dmp - having 2 similar
;                                                  things was frustrating
; Sep. 20, 2000 MWC RAM dump addresses are only 24 bit
; Sep. 20, 2000 MWC use "fix" to convert mem_dmp
; Sep. 25, 2000 MWC added packet size check - we were getting bogus packets
; Nov. 13, 2000 MWC added sc_id to nm1_pacmo1_fill and nm1_pacmo5_fill
; Dec. 22, 2000 MWC added raw_shdr
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4; also added nm1_pacmo4_fill call
; July 16, 2001 MWC added check of status from edi_header_fill; it used
;                   to be true that the status from the EDI header was
;                   always 1
; Jan.  3, 2002 MWC added PICK_WW_ONLY keyword check
; Jan. 14, 2002 MWC added ambient GEOS check
; Apr. 29, 2002 MWC now nm1_pacmo0_fill gets hdr rather than
;                   hdr.chan0_comp
; Feb. 21. 2005 MWC added sc_id to nm1_pacmo0_fill
;
; Calling Interface:
; packet        bytarr    (i) EDI science packet
; packet_number long      (i) EDI packet number
; packet_time   lonarr(2) (i) time of EDI packet
;
; Return Value:
; A sc_pick_enm_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; nm1_fill fills a sc_pick_enm_struct data structure.  Depending on
; the packing mode, only one of the pacmoX structures is filled.  The
; others are present, but empty.  This is not a user level function.
COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

NM1_SIZE = 980
BM2_SIZE = 992
RAW_SHDR_LOC = 8
NM1_MEM_DUMP = 8
BIG_MEM_DUMP_OFFSET = 72
BIG_MEM_DUMP_SIZE = 454

valid = 0
frame_counter = 0

nm1 = sc_pick_enm_struct
nm1.status = 1

size_check = n_elements(packet)
IF size_check NE NM1_SIZE AND $
  size_check NE BM2_size THEN BEGIN
    nm1.status = INVALID_EDI_DATA
    return, nm1
ENDIF

; fill the header
hdr = edi_header_fill(packet, packet_number, packet_time)
IF hdr.status LT 0 THEN BEGIN
    nm1.status = hdr.status
    return, nm1
ENDIF

;don't waste time on other science types
ww_only = getenv('PICK_WW_ONLY')
IF ww_only EQ 'TRUE' AND hdr.science_mode NE 5 THEN BEGIN
    return, nm1
ENDIF

; make sure the packet is nominal mode 1
IF (hdr.sub_mode NE 1) THEN BEGIN
    nm1.status = WRONG_TM_MODE
    return, nm1
ENDIF

; check for valid science mode
IF ((hdr.science_mode NE '1'x) AND $
    (hdr.science_mode NE '2'x) AND $
    (hdr.science_mode NE '5'x) AND $
    (hdr.science_mode NE '8'x) AND $
    (hdr.science_mode NE 'c'x) AND $
    (hdr.science_mode NE 'd'x) AND $
    (hdr.science_mode NE '11'x) AND $
    (hdr.science_mode NE '13'x) AND $
    (hdr.science_mode NE '15'x)) THEN BEGIN
    nm1.status = INVALID_SCIENCE_MODE
    return, nm1
ENDIF

nm1.hdr = hdr

; fill the mem_dump, obsolete?
FOR i = 0, 15 DO nm1.mem_dmp[i] = fix(packet[2*i+NM1_MEM_DUMP]) * '100'x + $
  fix(packet[2*i+NM1_MEM_DUMP+1])
nm1.raw_shdr = packet[RAW_SHDR_LOC:RAW_SHDR_LOC+31]

; depending on the packing mode, fill the proper pacmoX structure
IF nm1.hdr.mem_dump_bit GT 0 THEN BEGIN
    FOR i = 0, 15 DO BEGIN
        nm1.dmp_addr[i] = $
          long(packet[4*i+11]) * '10000'x + $
          long(packet[4*i+8]) * '100'x + $
          long(packet[4*i+9])
    ENDFOR
    FOR i = 0, BIG_MEM_DUMP_SIZE-1 DO BEGIN
        nm1.mem_dmp[i] = $
          fix(packet[2*i+BIG_MEM_DUMP_OFFSET]) * '100'x + $
          fix(packet[2*i+BIG_MEM_DUMP_OFFSET+1])
    ENDFOR
ENDIF ELSE BEGIN
; fill the secondary header which is meaningful only in non memory
; dump modes
    IF nm1.hdr.pacmo EQ 4 AND nm1.hdr.pga1_conf EQ 0 THEN BEGIN
        ;do nothing, pacmo4 has no secondary header until pga1 is configured
    ENDIF ELSE BEGIN
        packet_buf = packet[8:39]
        shdr = edi_sec_header_fill(nm1.hdr.science_mode, packet_buf)
    
        IF (shdr.status LT 0) THEN BEGIN
            nm1.status = shdr.status
            return, nm1
        ENDIF ELSE nm1.shdr = shdr
    ENDELSE

    CASE nm1.hdr.pacmo OF

        0:BEGIN
            dfgm = 0
            IF (hdr.science_mode EQ '11'x) THEN dfgm = 1
            amb_geos = 0
            IF (hdr.science_mode EQ '15'x) THEN amb_geos = 1
            pacmo0 = nm1_pacmo0_fill(packet, nm1.hdr, $
                                     dfgm, amb_geos, sc_id)
            nm1.pacmo0 = pacmo0
            nm1.status = pacmo0.status
        END
        
        1:BEGIN
            pacmo1 = nm1_pacmo1_fill(packet, nm1.hdr, sc_id)
            nm1.pacmo1 = pacmo1
            nm1.status = pacmo1.status
        END
        
        2:BEGIN
            pacmo2 = nm1_pacmo2_fill(packet)
            nm1.pacmo2 = pacmo2
            nm1.status = pacmo2.status
            IF ((nm1.hdr.science_mode EQ 1) AND $
                (packet[10] EQ 3 OR $
                 packet[10] GE 5)) THEN BEGIN
                flag = packet[19] AND '1'x
                IF (flag EQ 1) THEN $
                  nm1.pacmo2.bciapart = nm1.shdr.m1dgx.bciapart $
                ELSE nm1.pacmo2.bciapart = nm1.shdr.m1dgb.bciapart
            ENDIF
        END
        
        4:BEGIN
            pacmo4 = nm1_pacmo4_fill(packet, nm1.hdr.pga1_conf)
            nm1.pacmo4 = pacmo4
            nm1.status = pacmo4.status            
        END

        5:BEGIN
            pacmo5 = nm1_pacmo5_fill(packet, nm1.hdr, sc_id)
            nm1.pacmo5 = pacmo5
            nm1.status = pacmo5.status
        END
        
    ENDCASE
ENDELSE

return, nm1

END
