FUNCTION m1dgx_fill, sec_header
; CLUSTER II IDL Function
;
; Abstract: fill an EDI m1dgx data structure
;
; Created by: Mark Chutter, UNH 
; July 1, 1999
;
; Modified:
; Oct. 19, 1999 MWC used common block for structure definitions
; Dec.  8, 1999 MWC bciapart had wrong index
; Jan. 27, 2000 MWC changed init_tbl to init_table
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Jan. 14, 2002 MWC added amb_geos struct
;
; Calling Interface:
; sec_header_buf bytarr (i) secondary header of the EDI science packet 
;
; Return Value:
; A sc_pick_esm1dgx_struct structure is returned.  If the error field is
; not zero, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; m1dgx_fill fills an m1dgx data structure (sc_pick_esm1dgx_struct) from the
; secondary header of an EDI science packet according to the
; specifications of the EDI User's Manual

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

m1dgx = sc_pick_esm1dgx_struct
m = 0b

m1dgx.fctmr = long(sec_header[0]) * '100'xL + long(sec_header[1])
m1dgx.init_table = sec_header[2]
m1dgx.ss_limwi = ishft((sec_header[3] AND '80'x), -7)
m1dgx.energy = ishft((sec_header[3] AND '40'x), -6)
m = ishft((sec_header[3] AND '30'x), -4)

CASE m OF

    0:m1dgx.m = 16
    1:m1dgx.m = 8
    2:m1dgx.m = 4
    3:m1dgx.m = 2

ENDCASE

m1dgx.optics_state = sec_header[3] AND '0F'x
m1dgx.bcnx1 = sec_header[4]
m1dgx.bcnx2 = sec_header[5]
m1dgx.dtdtndx = sec_header[6] AND 'F0'x
m1dgx.fract = sec_header[6] AND '0F'x
m1dgx.sob = sec_header[7]
m1dgx.eeprom = fix(sec_header[8]) * '100'x + fix(sec_header[9])
m1dgx.bciapart = sec_header[10]
m1dgx.flag_bits = sec_header[11]
m1dgx.steps1 = sec_header[12]
m1dgx.steps2 = sec_header[13]
m1dgx.gdu1_cmd17 = fix(sec_header[14]) * '100'x + fix(sec_header[15])
m1dgx.perpx = fix(sec_header[16]) * '100'x + fix(sec_header[17])
m1dgx.perpy = fix(sec_header[18]) * '100'x + fix(sec_header[19])
m1dgx.perpz = fix(sec_header[20]) * '100'x + fix(sec_header[21])
m1dgx.x_offset1 = sec_header[22]
m1dgx.y_offset1 = sec_header[23]
m1dgx.x_offset2 = sec_header[24]
m1dgx.y_offset2 = sec_header[25]
m1dgx.x_step1 = sec_header[26]
m1dgx.y_step1 = sec_header[27]
m1dgx.x_step2 = sec_header[28]
m1dgx.y_step2 = sec_header[29]
m1dgx.valid = fix(sec_header[30]) * '100'x + fix(sec_header[31])

return, m1dgx
END
