FUNCTION m1_fill, sec_header
; CLUSTER II IDL Function
;
; Abstract: fill an EDI m1 data structure
;
; Created by: Mark Chutter, UNH 
; July 1, 1999
;
; Modified:
; Oct. 19, 1999 MWC used common block for structure definitions
; Jan. 27, 2000 MWC changed init_tbl to init_table
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Jan. 14, 2002 MWC added amb_geos struct
;
; Calling Interface:
; sec_header_buf bytarr (i) secondary header of the EDI science packet 
;
; Return Value:
; A sc_pick_esm1_struct structure is returned.  If the status field is
; less than zero, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; m1_fill fills an m1 data structure (sc_pick_esm1_struct) from the
; secondary header of an EDI science packet according to the
; specifications of the EDI User's Manual

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

m1 = sc_pick_esm1_struct
m = 0b

m1.fctmr = long(sec_header[0]) * '100'x + long(sec_header[1])
m1.init_table = sec_header[2]
m1.ss_limwi = ishft((sec_header[3] AND '80'x), -7)
m1.energy = ishft((sec_header[3] AND '40'x), -6)
m = ishft((sec_header[3] AND '30'x), -4)

CASE m OF

    0:m1.m = 16
    1:m1.m = 8
    2:m1.m = 4
    3:m1.m = 2

ENDCASE

m1.optics_state = sec_header[3] AND '0F'x
m1.bcnx1 = sec_header[4]
m1.bcnx2 = sec_header[5]
m1.dtdtndx = sec_header[6] AND 'F0'x
m1.fract = sec_header[6] AND '0F'x
m1.sob = sec_header[7]
m1.eeprom = fix(sec_header[8]) * '100'x + fix(sec_header[9])
m1.gdu1_cmd17 = fix(sec_header[14]) * '100'x + fix(sec_header[15])
m1.perpx = fix(sec_header[16]) * '100'x + fix(sec_header[17])
m1.perpy = fix(sec_header[18]) * '100'x + fix(sec_header[19])
m1.perpz = fix(sec_header[20]) * '100'x + fix(sec_header[21])
m1.valid = fix(sec_header[30]) * '100'x + fix(sec_header[31])

return, m1
END
