PRO get_tspin, sun_data, srp, srp1, Tspin
;
;  get_tspin.pro
;
;  created by: Mark Chutter, UNH
;  Mar. 14, 2000
;
;  Modified:
;  Apr. 28, 2000 MWC swap order of srps comes srp1 is earler than srp
;  May   4, 2000 MWC Tspin is supposed to be a long
;  May  19, 2000 MWC added error check to see if there are more than
;                    the maximum number of possible SRPs
;  Aug. 11, 2000 MWC made get_tspin more generic so that it can be
;                    used for various packet types
;  Nov.  9, 2000 MWC initialized Tspin
;  Nov. 21, 2000 MWC only update Tspin if it is less the 6 seconds
;
;  Calling Interface:
;  sun_data   bytarr(36) (i) sun data from SC HK
;  srp        lonarr(2)  (o) atime of first pulse
;  srp1       lonarr(2)  (o) atime of second pulse
;  Tspin      long       (o) spin period
;
;  Affected Variables:
;  last_srp, last_Tspin
;
;  Description:
;  get_tspin finds Sun Reference Pulses and calculates the spin period
;  If there are more than 2 srp in the current TMR, then something is
;  wrong in which case Tspin is set to -1L.

COMMON last_sun_data, last_srp, last_Tspin

status = 0
Tspin = 4000000

get_srp, sun_data, n_srp, srp, srp1

IF n_srp EQ 2 AND srp[0] GT srp1[0] THEN BEGIN
;make sure the srp that comes first is srp, the latter is srp1
    tmp = srp
    srp = srp1
    srp1 = tmp
ENDIF

;If there are no SRP's, then use the old Tspin

IF n_srp EQ 1 THEN BEGIN
    IF last_srp[0] EQ 0L THEN Tspin = 4000000L $; for very first srp in data
    ELSE BEGIN
        tmp_time = sub_ctime(srp, last_srp)
        Tspin = tmp_time[0] * 1000000L + tmp_time[1]
    ENDELSE
    last_srp = srp
    IF Tspin GT 6000000L THEN Tspin = last_Tspin $
    ELSE last_Tspin = Tspin
ENDIF

IF n_srp EQ 2 THEN BEGIN
    tmp_time = sub_ctime(srp1, srp)
    Tspin = tmp_time[0] * 1000000L + tmp_time[1]
    last_srp = srp1
    IF Tspin GT 6000000L THEN Tspin = last_Tspin $
    ELSE last_Tspin = Tspin
ENDIF
    
IF n_srp GT 2 THEN Tspin = -1L ;for error checking
   
END
